#include <stdio.h>
#include <unistd.h>

#include "libnomad/libnomad.h"

njb_t njbs[ NJB_MAX_DEVICES ];

static void scanning( NomadJukebox *jukebox, guint jobid, 
		gpointer data )
{
	printf( "Beginning track scan.....\n" );
}

static void scanned( NomadJukebox *jukebox, guint jobid,
		guint total, gpointer data )
{
	gboolean *done;
	
	done = (gboolean *)data;
	printf( "\n\nScanned: %i\n", total );
	*done = TRUE;
}

static void playlist_add( NomadJukebox *jukebox, guint jobid,
		guint total, const gchar *name, gpointer data )
{
	printf( "Added playlist: %s\n", name );
}

int main()
{
	guint number;
	gboolean done;
	NomadJukebox *jukebox;

	g_type_init();
	g_thread_init( NULL );
	
	NJB_Set_Unicode( NJB_UC_UTF8 );

	number = 0;
	if( NJB_Discover( njbs, 0, &number ) == -1 ) {
		fprintf( stderr, "Error discovering jukeboxes\n" );
	}
	if( number == 0 ) {
		fprintf( stderr, "no NJB devices found\n" );
		return 0;
	}
	
	jukebox = nomad_jukebox_new( &njbs[ 0 ] );
	if( ! nomad_jukebox_acquire( jukebox ) ) {
		fprintf( stderr, "failed to acquire jukebox\n" );
		return 0;
	}

	/* we must build a track list before we attempt to
	 * build a playlist */
	
	done = FALSE;
	g_signal_connect( G_OBJECT( jukebox ), "scanning_tracks",
			G_CALLBACK( scanning ), NULL );
	g_signal_connect( G_OBJECT( jukebox ), "scanned_tracks",
			G_CALLBACK( scanned ), &done );
	
	nomad_jukebox_build_tracklist( jukebox );
	while( ! done ) {
		usleep( 100 );
	}
	done = FALSE;

	g_signal_connect( G_OBJECT( jukebox ), "playlist_add",
			G_CALLBACK( playlist_add ), NULL );
	g_signal_connect( G_OBJECT( jukebox ), "scanned_playlists",
			G_CALLBACK( scanned ), &done );
	nomad_jukebox_build_playlist( jukebox );

	while( ! done ) {
		usleep( 100 );
	}
	
	nomad_jukebox_release( jukebox );

	return 0;
}
