#include <stdio.h>
#include <unistd.h>

#include "libnomad/libnomad.h"

njb_t njbs[ NJB_MAX_DEVICES ];

static void usage( NomadJukebox *jukebox, guint jobid,
		guint64 total, guint64 free, guint64 used,
		gpointer data )
{
	gboolean *done;

	done = (gboolean*)data;
	
	printf( "Using: %i meg of %i meg\nFree: %i meg\n",
			(int)(( used / 1024.0 ) / 1024.0 ), 
			(int)(( total / 1024.0 ) / 1024.0 ), 
			(int)(( free / 1024.0 ) / 1024.0 ) );

	*done = TRUE;
}

int main()
{
	guint number;
	gboolean done;
	NomadJukebox *jukebox;

	g_type_init();
	g_thread_init( NULL );
	
	NJB_Set_Unicode( NJB_UC_UTF8 );

	number = 0;
	if( NJB_Discover( njbs, 0, &number ) == -1 ) {
		fprintf( stderr, "Error discovering jukeboxes\n" );
	}
	if( number == 0 ) {
		fprintf( stderr, "no NJB devices found\n" );
		return 0;
	}
	
	jukebox = nomad_jukebox_new( &njbs[ 0 ] );
	if( ! nomad_jukebox_acquire( jukebox ) ) {
		fprintf( stderr, "failed to acquire jukebox" );
		return 0;
	}

	done = FALSE;
	g_signal_connect( G_OBJECT( jukebox ), "usage",
			G_CALLBACK( usage ), &done );
	
	nomad_jukebox_getusage( jukebox );
	while( ! done ) {
		usleep( 100 );
	}
	nomad_jukebox_release( jukebox );

	return 0;
}
