/*
 * Copyright (C) 2009, 2010  Daniel Borkmann <daniel@netsniff-ng.org> and 
 *                           Emmanuel Roullit <emmanuel@netsniff-ng.org>
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 2 of the License, or (at 
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

#ifndef _NET_PORTS_TCP_H_
#define _NET_PORTS_TCP_H_

#include <stdint.h>

struct port_tcp {
	uintptr_t id;
	char *port;
};

/* Partly taken from /etc/services and from Nmap's services file. */
static const struct port_tcp ports_tcp[] = {
	{1, "tcpmux"},
	{2, "compressnet"},
	{3, "compressnet"},
	{7, "echo"},
	{9, "discard"},
	{11, "systat"},
	{13, "daytime"},
	{15, "netstat"},
	{17, "qotd"},
	{19, "chargen"},
	{20, "ftp-data"},
	{21, "ftp"},
	{22, "ssh"},
	{23, "telnet"},
	{24, "priv-mail"},
	{25, "smtp"},
	{26, "rsftp"},
	{27, "nsw-fe"},
	{29, "msg-icp"},
	{31, "msg-auth"},
	{33, "dsp"},
	{35, "priv-print"},
	{37, "time"},
	{38, "rap"},
	{42, "nameserver"},
	{43, "whois"},
	{44, "mpm-flags"},
	{45, "mpm"},
	{47, "ni-ftp"},
	{48, "auditd"},
	{49, "tacacs"},
	{50, "re-mail-ck"},
	{51, "la-maint"},
	{52, "xns-time"},
	{53, "domain"},
	{54, "xns-ch"},
	{55, "isi-gl"},
	{56, "xns-auth"},
	{57, "priv-term"},
	{58, "xns-mail"},
	{59, "priv-file"},
	{65, "tacacs-ds"},
	{66, "sqlnet"},
	{67, "dhcps"},
	{68, "dhcpc"},
	{69, "tftp"},
	{70, "gopher"},
	{71, "netrjs-1"},
	{72, "netrjs-2"},
	{73, "netrjs-3"},
	{74, "netrjs-4"},
	{75, "priv-dial"},
	{76, "deos"},
	{77, "priv-rje"},
	{78, "vettcp"},
	{79, "finger"},
	{80, "http"},
	{81, "hosts2-ns"},
	{82, "xfer"},
	{83, "mit-ml-dev"},
	{84, "ctf"},
	{85, "mit-ml-dev"},
	{86, "mfcobol"},
	{87, "priv-term-l"},
	{88, "kerberos-sec"},
	{89, "su-mit-tg"},
	{90, "dnsix"},
	{91, "mit-dov"},
	{92, "npp"},
	{93, "dcp"},
	{94, "objcall"},
	{95, "supdup"},
	{96, "dixie"},
	{97, "swift-rvf"},
	{98, "linuxconf"},
	{99, "metagram"},
	{100, "newacct"},
	{101, "hostname"},
	{102, "iso-tsap"},
	{103, "gppitnp"},
	{104, "acr-nema"},
	{106, "pop3pw"},
	{108, "snagas"},
	{109, "pop2"},
	{110, "pop3"},
	{111, "rpcbind"},
	{112, "mcidas"},
	{113, "auth"},
	{114, "audionews"},
	{115, "sftp"},
	{116, "ansanotify"},
	{117, "uucp-path"},
	{118, "sqlserv"},
	{119, "nntp"},
	{120, "cfdptkt"},
	{122, "smakynet"},
	{123, "ntp"},
	{124, "ansatrader"},
	{125, "locus-map"},
	{127, "locus-con"},
	{128, "gss-xlicen"},
	{129, "pwdgen"},
	{130, "cisco-fna"},
	{132, "cisco-sys"},
	{133, "statsrv"},
	{135, "msrpc"},
	{136, "profile"},
	{137, "netbios-ns"},
	{138, "netbios-dgm"},
	{139, "netbios-ssn"},
	{141, "emfis-cntl"},
	{142, "bl-idm"},
	{143, "imap"},
	{144, "news"},
	{146, "iso-tp0"},
	{148, "cronus"},
	{149, "aed-512"},
	{150, "sql-net"},
	{151, "hems"},
	{157, "knet-cmp"},
	{158, "pcmail-srv"},
	{161, "snmp"},
	{162, "snmptrap"},
	{163, "cmip-man"},
	{168, "rsvd"},
	{173, "xyplex-mux"},
	{174, "mailq"},
	{176, "genrad-mux"},
	{177, "xdmcp"},
	{179, "bgp"},
	{180, "ris"},
	{181, "unify"},
	{182, "audit"},
	{184, "ocserver"},
	{185, "remote-kis"},
	{189, "qft"},
	{190, "gacp"},
	{191, "prospero"},
	{192, "osu-nms"},
	{193, "srmp"},
	{194, "irc"},
	{196, "dn6-smm-red"},
	{199, "smux"},
	{200, "src"},
	{201, "at-rtmp"},
	{202, "at-nbp"},
	{204, "at-echo"},
	{205, "at-5"},
	{206, "at-zis"},
	{209, "tam"},
	{210, "z39.50"},
	{211, "914c-g"},
	{212, "anet"},
	{213, "ipx"},
	{214, "vmpwscs"},
	{216, "atls"},
	{217, "dbase"},
	{219, "uarps"},
	{220, "imap3"},
	{221, "fln-spx"},
	{222, "rsh-spx"},
	{223, "cdc"},
	{248, "bhfhs"},
	{256, "fw1-secureremote"},
	{257, "fw1-mc-fwmodule"},
	{258, "fw1-mc-gui"},
	{259, "esro-gen"},
	{260, "openport"},
	{261, "nsiiops"},
	{262, "arcisdms"},
	{264, "bgmp"},
	{265, "maybe-fw1"},
	{280, "http-mgmt"},
	{308, "novastorbakcup"},
	{311, "asip-webadmin"},
	{315, "dpsi"},
	{316, "decauth"},
	{346, "zserv"},
	{350, "matip-type-a"},
	{351, "matip-type-b"},
	{352, "dtag-ste-sb"},
	{353, "ndsauth"},
	{355, "datex-asn"},
	{358, "shrinkwrap"},
	{360, "scoi2odialog"},
	{361, "semantix"},
	{362, "srssend"},
	{364, "aurora-cmgr"},
	{366, "odmr"},
	{369, "rpc2portmap"},
	{370, "codaauth2"},
	{373, "legent-1"},
	{380, "is99s"},
	{383, "hp-alarm-mgr"},
	{388, "unidata-ldm"},
	{389, "ldap"},
	{391, "synotics-relay"},
	{392, "synotics-broker"},
	{395, "netcp"},
	{397, "mptn"},
	{399, "iso-tsap-c2"},
	{400, "work-sol"},
	{401, "ups"},
	{402, "genie"},
	{403, "decap"},
	{404, "nced"},
	{406, "imsp"},
	{407, "timbuktu"},
	{408, "prm-sm"},
	{410, "decladebug"},
	{411, "rmt"},
	{412, "synoptics-trap"},
	{413, "smsp"},
	{414, "infoseek"},
	{415, "bnet"},
	{416, "silverplatter"},
	{417, "onmux"},
	{418, "hyper-g"},
	{419, "ariel1"},
	{420, "smpte"},
	{422, "ariel3"},
	{423, "opc-job-start"},
	{425, "icad-el"},
	{427, "svrloc"},
	{428, "ocs_cmu"},
	{432, "iasd"},
	{434, "mobileip-agent"},
	{435, "mobilip-mn"},
	{437, "comscm"},
	{438, "dsfgw"},
	{439, "dasp"},
	{440, "sgcp"},
	{441, "decvms-sysmgt"},
	{442, "cvc_hostd"},
	{443, "https"},
	{444, "snpp"},
	{445, "microsoft-ds"},
	{446, "ddm-rdb"},
	{447, "ddm-dfm"},
	{448, "ddm-ssl"},
	{449, "as-servermap"},
	{450, "tserver"},
	{451, "sfs-smp-net"},
	{452, "sfs-config"},
	{453, "creativeserver"},
	{454, "contentserver"},
	{456, "macon"},
	{457, "scohelp"},
	{458, "appleqtc"},
	{460, "skronk"},
	{462, "datasurfsrvsec"},
	{464, "kpasswd5"},
	{465, "smtps"},
	{466, "digital-vrc"},
	{470, "scx-proxy"},
	{472, "ljk-login"},
	{473, "hybrid-pop"},
	{475, "tcpnethaspsrv"},
	{475, "tcpnethaspsrv"},
	{479, "iafserver"},
	{480, "loadsrv"},
	{481, "dvs"},
	{485, "powerburst"},
	{486, "sstats"},
	{487, "saft"},
	{491, "go-login"},
	{492, "ticf-1"},
	{493, "ticf-2"},
	{496, "pim-rp-disc"},
	{497, "retrospect"},
	{500, "isakmp"},
	{501, "stmf"},
	{502, "asa-appl-proto"},
	{505, "mailbox-lm"},
	{507, "crs"},
	{509, "snare"},
	{510, "fcp"},
	{511, "passgo"},
	{512, "exec"},
	{513, "login"},
	{514, "shell"},
	{515, "printer"},
	{516, "videotex"},
	{518, "ntalk"},
	{522, "ulp"},
	{523, "ibm-db2"},
	{524, "ncp"},
	{525, "timed"},
	{526, "tempo"},
	{528, "custix"},
	{530, "courier"},
	{533, "netwall"},
	{535, "iiop"},
	{536, "opalis-rdv"},
	{538, "gdomap"},
	{540, "uucp"},
	{541, "uucp-rlogin"},
	{542, "commerce"},
	{543, "klogin"},
	{544, "kshell"},
	{545, "ekshell"},
	{548, "afp"},
	{552, "deviceshare"},
	{553, "pirp"},
	{554, "rtsp"},
	{555, "dsf"},
	{556, "remotefs"},
	{557, "openvms-sysipc"},
	{560, "rmonitor"},
	{561, "monitor"},
	{563, "snews"},
	{564, "9pfs"},
	{568, "ms-shuttle"},
	{569, "ms-rome"},
	{570, "meter"},
	{571, "umeter"},
	{572, "sonar"},
	{577, "vnas"},
	{578, "ipdd"},
	{582, "scc-security"},
	{583, "philips-vc"},
	{587, "submission"},
	{591, "http-alt"},
	{593, "http-rpc-epmap"},
	{596, "smsd"},
	{598, "sco-websrvrmg3"},
	{599, "acp"},
	{600, "ipcserver"},
	{603, "mnotes"},
	{606, "urm"},
	{607, "nqs"},
	{608, "sift-uft"},
	{609, "npmp-trap"},
	{610, "npmp-local"},
	{611, "npmp-gui"},
	{617, "sco-dtmgr"},
	{625, "apple-xsrvr-admin"},
	{626, "apple-imap-admin"},
	{628, "qmqp"},
	{631, "ipp"},
	{634, "ginad"},
	{636, "ldapssl"},
	{637, "lanserver"},
	{646, "ldp"},
	{660, "mac-srvr-admin"},
	{664, "secure-aux-bus"},
	{666, "doom"},
	{674, "acap"},
	{683, "corba-iiop"},
	{691, "resvc"},
	{704, "elcsd"},
	{706, "silc"},
	{709, "entrustmanager"},
	{709, "entrustmanager"},
	{723, "omfs"},
	{729, "netviewdm1"},
	{730, "netviewdm2"},
	{730, "netviewdm2"},
	{731, "netviewdm3"},
	{731, "netviewdm3"},
	{740, "netcp"},
	{740, "netcp"},
	{741, "netgw"},
	{742, "netrcs"},
	{744, "flexlm"},
	{747, "fujitsu-dev"},
	{748, "ris-cm"},
	{749, "kerberos-adm"},
	{750, "kerberos"},
	{751, "kerberos_master"},
	{752, "qrh"},
	{753, "rrh"},
	{754, "krb_prop"},
	{758, "nlogin"},
	{759, "con"},
	{760, "krbupdate"},
	{761, "kpasswd"},
	{762, "quotad"},
	{763, "cycleserv"},
	{764, "omserv"},
	{765, "webster"},
	{767, "phonebook"},
	{769, "vid"},
	{770, "cadlock"},
	{771, "rtip"},
	{773, "submit"},
	{774, "rpasswd"},
	{775, "entomb"},
	{776, "wpages"},
	{780, "wpgs"},
	{781, "hp-collector"},
	{782, "hp-managed-node"},
	{783, "spamassassin"},
	{786, "concert"},
	{787, "qsc"},
	{799, "controlit"},
	{800, "mdbs_daemon"},
	{801, "device"},
	{808, "ccproxy-http"},
	{871, "supfilesrv"},
	{873, "rsync"},
	{888, "accessbuilder"},
	{898, "sun-manageconsole"},
	{901, "samba-swat"},
	{902, "iss-realsecure"},
	{903, "iss-console-mgr"},
	{950, "oftep-rpc"},
	{953, "rndc"},
	{975, "securenetpro-sensor"},
	{989, "ftps-data"},
	{990, "ftps"},
	{992, "telnets"},
	{993, "imaps"},
	{994, "ircs"},
	{995, "pop3s"},
	{996, "xtreelic"},
	{997, "maitrd"},
	{998, "busboy"},
	{999, "garcon"},
	{1000, "cadlock"},
	{1002, "windows-icfw"},
	{1008, "ufsd"},
	{1023, "netvenuechat"},
	{1024, "kdm"},
	{1025, "NFS-or-IIS"},
	{1026, "LSA-or-nterm"},
	{1027, "IIS"},
	{1029, "ms-lsa"},
	{1030, "iad1"},
	{1031, "iad2"},
	{1032, "iad3"},
	{1033, "netinfo"},
	{1034, "zincite-a"},
	{1035, "multidropper"},
	{1040, "netsaint"},
	{1043, "boinc"},
	{1050, "java-or-OTGfileshare"},
	{1051, "optima-vnet"},
	{1052, "ddt"},
	{1055, "ansyslmd"},
	{1058, "nim"},
	{1059, "nimreg"},
	{1060, "polestar"},
	{1062, "veracity"},
	{1066, "fpo-fns"},
	{1067, "instl_boots"},
	{1068, "instl_bootc"},
	{1069, "cognex-insight"},
	{1076, "sns_credit"},
	{1080, "socks"},
	{1083, "ansoft-lm-1"},
	{1084, "ansoft-lm-2"},
	{1103, "xaudio"},
	{1109, "kpop"},
	{1110, "nfsd-status"},
	{1112, "msql"},
	{1127, "supfiledbg"},
	{1139, "cce3x"},
	{1158, "lsnr"},
	{1167, "cisco-ipsla"},
	{1178, "skkserv"},
	{1212, "lupa"},
	{1214, "fasttrack"},
	{1218, "aeroflight-ads"},
	{1220, "quicktime"},
	{1222, "nerv"},
	{1234, "hotline"},
	{1241, "nessus"},
	{1248, "hermes"},
	{1270, "ssserver"},
	{1311, "rxmon"},
	{1337, "waste"},
	{1346, "alta-ana-lm"},
	{1347, "bbn-mmc"},
	{1348, "bbn-mmx"},
	{1349, "sbook"},
	{1350, "editbench"},
	{1351, "equationbuilder"},
	{1352, "lotusnotes"},
	{1353, "relief"},
	{1354, "rightbrain"},
	{1355, "intuitive-edge"},
	{1356, "cuillamartin"},
	{1357, "pegboard"},
	{1358, "connlcli"},
	{1359, "ftsrv"},
	{1360, "mimer"},
	{1361, "linx"},
	{1362, "timeflies"},
	{1363, "ndm-requester"},
	{1364, "ndm-server"},
	{1365, "adapt-sna"},
	{1366, "netware-csp"},
	{1367, "dcs"},
	{1368, "screencast"},
	{1369, "gv-us"},
	{1370, "us-gv"},
	{1371, "fc-cli"},
	{1372, "fc-ser"},
	{1373, "chromagrafx"},
	{1374, "molly"},
	{1376, "ibm-pps"},
	{1379, "dbreporter"},
	{1381, "apple-licman"},
	{1383, "gwha"},
	{1384, "os-licman"},
	{1385, "atex_elmd"},
	{1386, "checksum"},
	{1387, "cadsi-lm"},
	{1388, "objective-dbc"},
	{1389, "iclpv-dm"},
	{1390, "iclpv-sc"},
	{1391, "iclpv-sas"},
	{1393, "iclpv-nls"},
	{1394, "iclpv-nlc"},
	{1395, "iclpv-wsm"},
	{1396, "dvl-activemail"},
	{1397, "audio-activmail"},
	{1398, "video-activmail"},
	{1399, "cadkey-licman"},
	{1400, "cadkey-tablet"},
	{1401, "goldleaf-licman"},
	{1402, "prm-sm-np"},
	{1403, "prm-nm-np"},
	{1404, "igi-lm"},
	{1405, "ibm-res"},
	{1407, "dbsa-lm"},
	{1408, "sophia-lm"},
	{1409, "here-lm"},
	{1410, "hiq"},
	{1411, "af"},
	{1412, "innosys"},
	{1413, "innosys-acl"},
	{1414, "ibm-mqseries"},
	{1416, "novell-lu6.2"},
	{1417, "timbuktu-srv1"},
	{1418, "timbuktu-srv2"},
	{1419, "timbuktu-srv3"},
	{1420, "timbuktu-srv4"},
	{1422, "autodesk-lm"},
	{1423, "essbase"},
	{1424, "hybrid"},
	{1426, "sas-1"},
	{1427, "mloadd"},
	{1429, "nms"},
	{1430, "tpdu"},
	{1432, "blueberry-lm"},
	{1433, "ms-sql-s"},
	{1434, "ms-sql-m"},
	{1435, "ibm-cics"},
	{1436, "sas-2"},
	{1437, "tabula"},
	{1438, "eicon-server"},
	{1439, "eicon-x25"},
	{1440, "eicon-slp"},
	{1441, "cadis-1"},
	{1442, "cadis-2"},
	{1443, "ies-lm"},
	{1444, "marcam-lm"},
	{1445, "proxima-lm"},
	{1446, "ora-lm"},
	{1448, "oc-lm"},
	{1449, "peport"},
	{1451, "infoman"},
	{1453, "genie-lm"},
	{1454, "interhdl_elmd"},
	{1455, "esl-lm"},
	{1456, "dca"},
	{1457, "valisys-lm"},
	{1458, "nrcabq-lm"},
	{1459, "proshare1"},
	{1461, "ibm_wrless_lan"},
	{1462, "world-lm"},
	{1464, "msl_lmd"},
	{1465, "pipes"},
	{1466, "oceansoft-lm"},
	{1467, "csdmbase"},
	{1469, "aal-lm"},
	{1470, "uaiact"},
	{1472, "csdm"},
	{1473, "openmath"},
	{1474, "telefinder"},
	{1475, "taligent-lm"},
	{1476, "clvm-cfg"},
	{1479, "dberegister"},
	{1480, "pacerforum"},
	{1482, "miteksys-lm"},
	{1483, "afs"},
	{1484, "confluent"},
	{1486, "nms_topo_serv"},
	{1488, "docstor"},
	{1491, "anynetgateway"},
	{1492, "stone-design-1"},
	{1493, "netmap_lm"},
	{1494, "citrix-ica"},
	{1495, "cvc"},
	{1496, "liberty-lm"},
	{1497, "rfx-lm"},
	{1498, "watcom-sql"},
	{1499, "fhc"},
	{1500, "vlsi-lm"},
	{1501, "sas-3"},
	{1502, "shivadiscovery"},
	{1503, "imtc-mcs"},
	{1505, "funkproxy"},
	{1507, "symplex"},
	{1508, "diagmond"},
	{1509, "robcad-lm"},
	{1510, "mvx-lm"},
	{1511, "3l-l1"},
	{1513, "fujitsu-dtc"},
	{1515, "ifor-protocol"},
	{1516, "vpad"},
	{1517, "vpac"},
	{1518, "vpvd"},
	{1519, "vpvc"},
	{1521, "oracle"},
	{1522, "rna-lm"},
	{1523, "cichild-lm"},
	{1524, "ingreslock"},
	{1525, "orasrv"},
	{1526, "pdap-np"},
	{1527, "tlisrv"},
	{1528, "mciautoreg"},
	{1529, "support"},
	{1531, "rap-listen"},
	{1532, "miroconnect"},
	{1533, "virtual-places"},
	{1535, "ampr-info"},
	{1537, "sdsc-lm"},
	{1538, "3ds-lm"},
	{1539, "intellistor-lm"},
	{1540, "rds"},
	{1541, "rds2"},
	{1542, "gridgen-elmd"},
	{1543, "simba-cs"},
	{1544, "aspeclmd"},
	{1545, "vistium-share"},
	{1547, "laplink"},
	{1548, "axon-lm"},
	{1549, "shivahose"},
	{1550, "3m-image-lm"},
	{1551, "hecmtl-db"},
	{1552, "pciarray"},
	{1600, "issd"},
	{1650, "nkd"},
	{1651, "shiva_confsrvr"},
	{1652, "xnmp"},
	{1661, "netview-aix-1"},
	{1662, "netview-aix-2"},
	{1663, "netview-aix-3"},
	{1664, "netview-aix-4"},
	{1666, "netview-aix-6"},
	{1667, "netview-aix-7"},
	{1668, "netview-aix-8"},
	{1670, "netview-aix-10"},
	{1671, "netview-aix-11"},
	{1672, "netview-aix-12"},
	{1680, "CarbonCopy"},
	{1700, "mps-raft"},
	{1717, "fj-hdnet"},
	{1720, "H.323/Q.931"},
	{1723, "pptp"},
	{1755, "wms"},
	{1761, "landesk-rc"},
	{1762, "landesk-rc"},
	{1763, "landesk-rc"},
	{1782, "hp-hcip"},
	{1827, "pcm"},
	{1863, "msnp"},
	{1864, "paradym-31"},
	{1900, "upnp"},
	{1935, "rtmp"},
	{1984, "bigbrother"},
	{1986, "licensedaemon"},
	{1987, "tr-rsrb-p1"},
	{1988, "tr-rsrb-p2"},
	{1989, "tr-rsrb-p3"},
	{1990, "stun-p1"},
	{1991, "stun-p2"},
	{1992, "stun-p3"},
	{1993, "snmp-tcp-port"},
	{1993, "snmp-tcp-port"},
	{1994, "stun-port"},
	{1995, "perf-port"},
	{1996, "tr-rsrb-port"},
	{1997, "gdp-port"},
	{1998, "x25-svc-port"},
	{1999, "tcp-id-port"},
	{1999, "tcp-id-port"},
	{2000, "cisco-sccp"},
	{2001, "dc"},
	{2002, "globe"},
	{2003, "finger"},
	{2004, "mailbox"},
	{2005, "deslogin"},
	{2006, "invokator"},
	{2007, "dectalk"},
	{2008, "conf"},
	{2009, "news"},
	{2010, "search"},
	{2011, "raid-cc"},
	{2012, "ttyinfo"},
	{2013, "raid-am"},
	{2014, "troff"},
	{2015, "cypress"},
	{2016, "bootserver"},
	{2018, "terminaldb"},
	{2019, "whosockami"},
	{2020, "xinupageserver"},
	{2021, "servexec"},
	{2022, "down"},
	{2023, "xinuexpansion3"},
	{2024, "xinuexpansion4"},
	{2025, "ellpack"},
	{2026, "scrabble"},
	{2027, "shadowserver"},
	{2028, "submitserver"},
	{2030, "device2"},
	{2033, "glogger"},
	{2034, "scoremgr"},
	{2035, "imsldoc"},
	{2038, "objectmanager"},
	{2040, "lam"},
	{2041, "interbase"},
	{2042, "isis"},
	{2043, "isis-bcast"},
	{2044, "rimsl"},
	{2045, "cdfunc"},
	{2046, "sdfunc"},
	{2047, "dls"},
	{2048, "dls-monitor"},
	{2049, "nfs"},
	{2053, "knetd"},
	{2064, "dnet-keyproxy"},
	{2065, "dlsrpn"},
	{2067, "dlswpn"},
	{2068, "advocentkvm"},
	{2103, "zephyr-clt"},
	{2105, "eklogin"},
	{2106, "ekshell"},
	{2108, "rkinit"},
	{2111, "kx"},
	{2112, "kip"},
	{2120, "kauth"},
	{2121, "ccproxy-ftp"},
	{2148, "veritas-ucl"},
	{2161, "apc-agent"},
	{2201, "ats"},
	{2232, "ivs-video"},
	{2241, "ivsd"},
	{2301, "compaqdiag"},
	{2307, "pehelp"},
	{2383, "ms-olap4"},
	{2401, "cvspserver"},
	{2430, "venus"},
	{2431, "venus-se"},
	{2432, "codasrv"},
	{2433, "codasrv-se"},
	{2500, "rtsserv"},
	{2501, "rtsclient"},
	{2564, "hp-3000-telnet"},
	{2600, "zebrasrv"},
	{2601, "zebra"},
	{2602, "ripd"},
	{2604, "ospfd"},
	{2605, "bgpd"},
	{2627, "webster"},
	{2628, "dict"},
	{2638, "sybase"},
	{2701, "sms-rcinfo"},
	{2702, "sms-xfer"},
	{2766, "listen"},
	{2809, "corbaloc"},
	{2903, "extensisportfolio"},
	{2967, "symantec-av"},
	{2998, "iss-realsec"},
	{3000, "ppp"},
	{3001, "nessus"},
	{3005, "deslogin"},
	{3006, "deslogind"},
	{3025, "slnp"},
	{3045, "slnp"},
	{3049, "cfs"},
	{3052, "powerchute"},
	{3064, "dnet-tstproxy"},
	{3086, "sj3"},
	{3128, "squid-http"},
	{3141, "vmodem"},
	{3260, "iscsi"},
	{3264, "ccmail"},
	{3268, "globalcatLDAP"},
	{3269, "globalcatLDAPssl"},
	{3283, "netassistant"},
	{3292, "meetingmaker"},
	{3299, "saprouter"},
	{3306, "mysql"},
	{3333, "dec-notes"},
	{3372, "msdtc"},
	{3389, "ms-term-serv"},
	{3397, "saposs"},
	{3398, "sapcomm"},
	{3399, "sapeps"},
	{3421, "bmap"},
	{3456, "vat"},
	{3457, "vat-control"},
	{3531, "peerenabler"},
	{3632, "distccd"},
	{3689, "rendezvous"},
	{3690, "svn"},
	{3863, "asap-tcp"},
	{3868, "diameter"},
	{3900, "udt_os"},
	{3905, "mupdate"},
	{3984, "mapper-nodemgr"},
	{3985, "mapper-mapethd"},
	{3986, "mapper-ws_ethd"},
	{3999, "remoteanything"},
	{4000, "remoteanything"},
	{4002, "mlchat-proxy"},
	{4008, "netcheque"},
	{4045, "lockd"},
	{4125, "rww"},
	{4132, "nuts_dem"},
	{4133, "nuts_bootp"},
	{4144, "wincim"},
	{4190, "sieve"},
	{4199, "eims-admin"},
	{4224, "xtell"},
	{4321, "rwhois"},
	{4333, "msql"},
	{4343, "unicall"},
	{4443, "pharos"},
	{4444, "krb524"},
	{4480, "proxy-plus"},
	{4500, "sae-urn"},
	{4557, "fax"},
	{4559, "hylafax"},
	{4660, "mosmig"},
	{4662, "edonkey"},
	{4672, "rfa"},
	{4827, "squid-htcp"},
	{4899, "radmin"},
	{4987, "maybe-veritas"},
	{4998, "maybe-veritas"},
	{5000, "upnp"},
	{5001, "commplex-link"},
	{5002, "rfe"},
	{5003, "filemaker"},
	{5009, "airport-admin"},
	{5010, "telelpathstart"},
	{5011, "telelpathattack"},
	{5050, "mmcc"},
	{5051, "ida-agent"},
	{5060, "sip"},
	{5061, "sip-tls"},
	{5100, "admd"},
	{5101, "admdog"},
	{5102, "admeng"},
	{5145, "rmonitor_secure"},
	{5190, "aol"},
	{5191, "aol-1"},
	{5193, "aol-3"},
	{5222, "xmpp"},
	{5232, "sgi-dgl"},
	{5300, "hacl-hb"},
	{5301, "hacl-gs"},
	{5302, "hacl-cfg"},
	{5303, "hacl-probe"},
	{5308, "cfengine"},
	{5400, "pcduo-old"},
	{5405, "pcduo"},
	{5431, "park-agent"},
	{5432, "postgresql"},
	{5490, "connect-proxy"},
	{5500, "hotline"},
	{5510, "secureidprop"},
	{5520, "sdlog"},
	{5530, "sdserv"},
	{5550, "sdadmind"},
	{5555, "freeciv"},
	{5560, "isqlplus"},
	{5631, "pcanywheredata"},
	{5632, "pcanywherestat"},
	{5666, "nrpe"},
	{5672, "amqp"},
	{5679, "activesync"},
	{5680, "canna"},
	{5713, "proshareaudio"},
	{5714, "prosharevideo"},
	{5717, "prosharenotify"},
	{5800, "vnc-http"},
	{5801, "vnc-http-1"},
	{5802, "vnc-http-2"},
	{5803, "vnc-http-3"},
	{5900, "vnc"},
	{5901, "vnc-1"},
	{5902, "vnc-2"},
	{5903, "vnc-3"},
	{5977, "ncd-pref-tcp"},
	{5978, "ncd-diag-tcp"},
	{5997, "ncd-pref"},
	{5998, "ncd-diag"},
	{5999, "ncd-conf"},
	{6000, "X11"},
	{6001, "X11:1"},
	{6002, "X11:2"},
	{6003, "X11:3"},
	{6004, "X11:4"},
	{6005, "X11:5"},
	{6006, "X11:6"},
	{6007, "X11:7"},
	{6008, "X11:8"},
	{6009, "X11:9"},
	{6017, "xmail-ctrl"},
	{6050, "arcserve"},
	{6059, "X11:59"},
	{6101, "backupexec"},
	{6103, "RETS-or-BackupExec"},
	{6105, "isdninfo"},
	{6106, "isdninfo"},
	{6110, "softcm"},
	{6111, "spc"},
	{6112, "dtspc"},
	{6141, "meta-corp"},
	{6142, "aspentec-lm"},
	{6143, "watershed-lm"},
	{6145, "statsci2-lm"},
	{6146, "lonewolf-lm"},
	{6147, "montage-lm"},
	{6222, "radmind"},
	{6346, "gnutella"},
	{6347, "gnutella2"},
	{6400, "crystalreports"},
	{6401, "crystalenterprise"},
	{6502, "netop-rc"},
	{6543, "mythtv"},
	{6544, "mythtv"},
	{6547, "powerchuteplus"},
	{6548, "powerchuteplus"},
	{6588, "analogx"},
	{6662, "radmind"},
	{6665, "irc"},
	{6666, "irc"},
	{6667, "irc"},
	{6668, "irc"},
	{6669, "irc"},
	{6670, "irc"},
	{6699, "napster"},
	{6700, "carracho"},
	{6701, "carracho"},
	{6789, "ibm-db2-admin"},
	{6881, "bittorrent-tracker"},
	{6969, "acmsoda"},
	{7000, "afs3-fileserver"},
	{7001, "afs3-callback"},
	{7002, "afs3-prserver"},
	{7003, "afs3-vlserver"},
	{7004, "afs3-kaserver"},
	{7005, "afs3-volser"},
	{7006, "afs3-errors"},
	{7007, "afs3-bos"},
	{7008, "afs3-update"},
	{7009, "afs3-rmtsys"},
	{7010, "ups-onlinet"},
	{7070, "realserver"},
	{7100, "font-service"},
	{7200, "fodms"},
	{7201, "dlip"},
	{7273, "openmanage"},
	{7326, "icb"},
	{7464, "pythonds"},
	{7597, "qaz"},
	{7634, "hddtemp"},
	{7937, "nsrexecd"},
	{7938, "lgtomapper"},
	{8000, "http-alt"},
	{8002, "teradataordbms"},
	{8007, "ajp12"},
	{8008, "http"},
	{8009, "ajp13"},
	{8010, "xmpp"},
	{8021, "ftp-proxy"},
	{8076, "slnp"},
	{8080, "http-proxy"},
	{8081, "blackice-icecap"},
	{8082, "blackice-alerts"},
	{8118, "privoxy"},
	{8123, "polipo"},
	{8192, "sophos"},
	{8193, "sophos"},
	{8194, "sophos"},
	{8443, "https-alt"},
	{8471, "pim-port"},
	{8770, "apple-iphoto"},
	{8888, "sun-answerbook"},
	{8892, "seosload"},
	{9000, "cslistener"},
	{9001, "tor-orport"},
	{9040, "tor-trans"},
	{9050, "tor-socks"},
	{9051, "tor-control"},
	{9084, "aurora"},
	{9090, "zeus-admin"},
	{9100, "jetdirect"},
	{9101, "jetdirect"},
	{9102, "jetdirect"},
	{9103, "jetdirect"},
	{9104, "jetdirect"},
	{9105, "jetdirect"},
	{9106, "jetdirect"},
	{9107, "jetdirect"},
	{9111, "DragonIDSConsole"},
	{9152, "ms-sql2000"},
	{9200, "wap-wsp"},
	{9418, "git"},
	{9535, "man"},
	{9594, "msgsys"},
	{9595, "pds"},
	{9876, "sd"},
	{9900, "iua"},
	{9991, "issa"},
	{9992, "issc"},
	{9999, "abyss"},
	{10000, "snet-sensor-mgmt"},
	{10005, "stel"},
	{10082, "amandaidx"},
	{10083, "amidxtape"},
	{11371, "pksd"},
	{12000, "cce4x"},
	{12345, "netbus"},
	{12346, "netbus"},
	{13701, "netbackup"},
	{13713, "netbackup"},
	{13714, "netbackup"},
	{13715, "netbackup"},
	{13718, "netbackup"},
	{13720, "netbackup"},
	{13721, "netbackup"},
	{13722, "netbackup"},
	{13782, "netbackup"},
	{13783, "netbackup"},
	{14001, "sua"},
	{14141, "bo2k"},
	{15000, "hydap"},
	{15151, "bo2k"},
	{16080, "osxwebadmin"},
	{16444, "overnet"},
	{17007, "isode-dua"},
	{17300, "kuang2"},
	{18000, "biimenu"},
	{18181, "opsec-cvp"},
	{18182, "opsec-ufp"},
	{18183, "opsec-sam"},
	{18184, "opsec-lea"},
	{18187, "opsec-ela"},
	{19150, "gkrellm"},
	{20005, "btx"},
	{22273, "wnn6"},
	{26208, "wnn6_DS"},
	{27000, "flexlm0"},
	{27001, "flexlm1"},
	{27002, "flexlm2"},
	{27003, "flexlm3"},
	{27005, "flexlm5"},
	{27007, "flexlm7"},
	{27009, "flexlm9"},
	{27010, "flexlm10"},
	{27374, "subseven"},
	{27665, "Trinoo_Master"},
	{31337, "Elite"},
	{31416, "boinc"},
	{32770, "sometimes-rpc3"},
	{32771, "sometimes-rpc5"},
	{32772, "sometimes-rpc7"},
	{32773, "sometimes-rpc9"},
	{32774, "sometimes-rpc11"},
	{32775, "sometimes-rpc13"},
	{32776, "sometimes-rpc15"},
	{32777, "sometimes-rpc17"},
	{32778, "sometimes-rpc19"},
	{32779, "sometimes-rpc21"},
	{32780, "sometimes-rpc23"},
	{32786, "sometimes-rpc25"},
	{32787, "sometimes-rpc27"},
	{38037, "landesk-cba"},
	{38292, "landesk-cba"},
	{43188, "reachout"},
	{44334, "tinyfw"},
	{44442, "coldfusion-auth"},
	{44443, "coldfusion-auth"},
	{47557, "dbbrowse"},
	{49400, "compaqdiag"},
	{50000, "iiimsf"},
	{50002, "iiimsf"},
	{54320, "bo2k"},
	{62078, "iphone-sync"},
	{65301, "pcanywhere"},
};

char port_tcp_unknown[] = "Unknown";

#endif				/* _NET_PORTS_TCP_H_ */
