/* Copyright (C) 2004 Per Johansson
	
	This file is part of netGo.

    netGo is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    netGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with netGo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <qprocess.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qtextbrowser.h>

#ifndef PROCESS_H
#define PROCESS_H

// Class handling all the processes.
class Process : public QObject
{			
	Q_OBJECT
			
	public:
		// Constructor.
		Process(QTextBrowser *procBrowser=0, QPushButton *okButton=0);
		
		// Function for executing a profile.
		void runProfile(const QString &name);
		
		// The textbrowser that all the process-output is printed on.
		QTextBrowser *browser;
		
		// The button that we freeze during the execution of a profile.
		QPushButton *okBut;
		
		// QProcess-objects.
		QProcess *ifaceDownProc;
		QProcess *killDhcpProc;
		QProcess *dhcpProc;
		QProcess *fetchIpProc;
		QProcess *ipProc;
		QProcess *netmaskProc;
		QProcess *gwProc;
		QProcess *scriptProc;
		QProcess *modeProc;
		QProcess *essidProc;
		QProcess *keyProc;
		
		// QStringList's for storing the commands.
		QStringList ifaceDown;
		QStringList killDhcp;
		QStringList setIp;
		QStringList setDhcp;
		QStringList fetchIp;
		QStringList setNetmask;
		QStringList setGw;
		QStringList setScript;
		QStringList setMode;
		QStringList setEssid;
		QStringList setKey;
		
		// Enum used for the processes.
		enum { NONE, MODE, ESSID, KEY, IFACEDOWN, KILLDHCP, DHCP, FETCHIP, STATICIP, NETMASK, GW, SCRIPT };	
		
		// This variable holds the profile that is about to get executed                                      .
		int current;
		// This variable is used for error report in dhcp-process.
		int DHCP_ERROR;
		// This variable contains the process that is executing at the moment.
		int CURRENT_PROC;
		
		// Bash escape sequences for coloured text.
		QString blue;
		QString BLUE;
		QString green;
		QString GREEN;
		QString red;
		QString RED;
		QString magenta;
		QString MAGENTA;
		QString cyan;
		QString CYAN;
		QString normal;
		QString NORMAL;
				
	public slots:
		
		// SLOTS that executes the network-settings.
		void startModeProc();
		void startEssidProc();
		void startKeyProc();
		void startIfaceDown();
		void startKillDhcp();
		void startDhcpProc();
		void startFetchIpProc();
		void startIpProc();
		void startNetmaskProc();
		void startGwProc();
		void startNsProc();
		void startScriptProc();
				
		// Functions for displaying error-msg's.
		void ifaceDownErr();
		void killDhcpErr();
		void dhcpErr();
		void ipErr();
		void netmaskErr();
		void gwErr();
		void scriptErr();
		void modeErr();
		void essidErr();
		void keyErr();
		
		// Function for fetching the current ip from ifconfig.
		void readIp();
		
		// Function that terminates the current network-process.
		void terminateProc();
		
		// Function for a safe exit.
		void cleanUp();
	signals:
		void procsFinished();	
};

#endif
