 geometry = ngsolve/pde_tutorial/capacitor.in2d
mesh = ngsolve/pde_tutorial/capacitor.vol
# geometry = ngsolve/pde_tutorial/capacitor_round.in2d
# mesh = ngsolve/pde_tutorial/capacitor_round.vol

define constant geometryorder = 1
# define constant refinep = 1

define coefficient coef_eps
1,

define coefficient coef_alpha
0, 1e5, 1e5, 

define coefficient coef_g
0, 1e5, -1e5,
 
define fespace v -order=15 -augmented=1
define gridfunction u -fespace=v

define bilinearform a -fespace=v -symmetric
laplace coef_eps
robin coef_alpha

define linearform f -fespace=v
neumann coef_g

# define preconditioner c -type=direct -bilinearform=a
# define preconditioner c -type=local -bilinearform=a
define preconditioner c -type=multigrid -bilinearform=a -smoothingsteps=1


numproc bvp np1 -bilinearform=a -linearform=f -gridfunction=u -preconditioner=c -maxsteps=1000


numproc drawflux np2 -bilinearform=a -solution=u -label=flux



# evaluate energy:

define bilinearform aeval -fespace=v -symmetric -nonassemble
laplace coef_eps

numproc evaluate npeval  -bilinearform=aeval -gridfunction=u -gridfunction2=u





# error estimator:

define fespace verr -l2 -order=0
define gridfunction err -fespace=verr

numproc zzerrorestimator np3 -bilinearform=a -linearform=f -solution=u -error=err -minlevel=1
# numproc rtzzerrorestimator npee -bilinearform=a -solution=u -error=err
numproc markelements np4 -error=err -minlevel=1 -factor=0.5


numproc drawflux df1 -marked 
numproc drawflux df2 -order
