#ifndef FILE_VEFC
#define FILE_VEFC

/*********************************************************************/
/* File:   vefc.hpp                                                  */
/* Author: Joachim Schoeberl                                         */
/* Date:   17. July. 2002                                            */
/*********************************************************************/

/** 
    High order preconditioner
*/



///
class VEFC_Matrix : public BaseMatrix
{
  ///
  const BaseMatrix & mat;
  ///
  const FESpace & fes;
  ///
  BaseBlockJacobiPrecond * jacobi;
  ///
  BaseMatrix * coarseprecond;
public:
  ///
  VEFC_Matrix (const BaseMatrix & amat, 
	       const FESpace & fes);
  ///
  ~VEFC_Matrix ();
  ///
  virtual void Mult (const BaseVector & x, BaseVector & y) const;
  ///
  virtual BaseVector * CreateVector () const;
  ///
  virtual ostream & Print (ostream & s) const;

  virtual int VHeight() const
  {
    return mat.Height();
  }

  virtual int VWidth() const
  {
    return mat.VWidth();
  }

  virtual void MemoryUsage (ARRAY<MemoryUsageStruct*> & mu) const;
};


#endif
