/*********************************************************************/
/* File:   l2hofe.cpp                                                */
/* Author: Start                                                     */
/* Date:   6. Feb. 2003                                              */
/*********************************************************************/


#include <fem.hpp>
namespace ngfem
{
  using namespace ngfem;
  
  L2HighOrderFiniteElement ::   
  L2HighOrderFiniteElement (int dim, ELEMENT_TYPE aeltype)
    : NodalFiniteElement (dim, aeltype, -1, -1) 
  { 
    ;
  }
  
  void L2HighOrderFiniteElement::
  SetOrder (int o)
  {
    order = o;   

    ComputeNDof();
  }


  

  /* *********************** Triangle  **********************/

  L2HighOrderTrig :: L2HighOrderTrig (int aorder)
    : L2HighOrderFiniteElement(2, ET_TRIG)
  {
    order = aorder;
    ComputeNDof();
  }


  void L2HighOrderTrig :: ComputeNDof()
  {
    ndof = (order+1) * (order+2) / 2;
  }


  void L2HighOrderTrig :: CalcShape (const IntegrationPoint & ip, 
				     FlatVector<> shape) const
  {
    double x = ip(0);
    double y = ip(1);
    int ii = 0;

    int n = order;

    ArrayMem<double, 20> polx(n+1), poly(n+1);

    ScaledLegendrePolynomial (n, x, 1-y, polx);
    LegendrePolynomial (n, 2*y-1, poly);
    
    for (int i = 0; i <= order; i++)
      for (int j = 0; j <= order-i; j++)
	shape(ii++) = polx[i] * poly[j];
  }

}

