#ifndef FILE_HCURLHOFE_
#define FILE_HCURLHOFE_ 

/*********************************************************************/
/* File:   hcurlhofe.hpp                                             */
/* Author: Sabine Zaglmayr                                           */
/* Date:   20. Maerz 2003                                            */
/*********************************************************************/
   

/**
   High order H(curl) finite element
 */
template <int D>
class HCurlHighOrderFiniteElement : public HCurlFiniteElementD<D> 
{
 
public:
  //  enum { DIM = D };

protected:
  // int ndof; 
  int vnums[8]; 
  int order_inner;
  int order_face[6];
  int order_edge[12];
  int ndof_edge; 
  int ned; // number of edges in element  
  int nv; // number of vertices in element 
  int nf; // number of faces in element
  int usegrad_face[6]; 
  int usegrad_cell; 
  int usegrad_edge[12]; 
 
  
public:
  ///
  HCurlHighOrderFiniteElement (ELEMENT_TYPE aeltype);

  void SetVertexNumbers (FlatArray<int> & avnums);
  void SetOrderInner (int oi);
  void SetOrderFace (FlatArray<int> & of);
  void SetOrderEdge (FlatArray<int> & oen);
  void SetUsegradEdge(FlatArray<int> & uge); 
  void SetUsegradFace(FlatArray<int> & ugf); 
  void SetUsegradCell(int ugc); 
  
  virtual void ComputeNDof () = 0;
 
};
 
/// 
template <class T_ORTHOPOL> 
class HCurlHighOrderSegm:  public HCurlHighOrderFiniteElement<1>
{
public:
  
  HCurlHighOrderSegm (int aorder);
  virtual void ComputeNDof();
 
  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatMatrixFixWidth<1> shape) const;
  
};

///
template <class T_ORTHOPOL> 
class HCurlHighOrderTrig : public HCurlHighOrderFiniteElement<2>
{
  typedef TrigShapesInnerLegendre T_INNERSHAPES; 
  typedef VertexExtensionOptimal<3> T_VERTEXSHAPES;
public:

  HCurlHighOrderTrig (int aorder);
  virtual void ComputeNDof();
 
  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatMatrixFixWidth<2> shape) const;
  
  /// compute Curl of shape 
  virtual void CalcCurlShape (const IntegrationPoint & ip, 
			      FlatMatrixFixWidth<1> curlshape) const; 
};


///
template <class T_ORTHOPOL>
class HCurlHighOrderQuad : public HCurlHighOrderFiniteElement<2>
{
public:

  HCurlHighOrderQuad (int aorder);
  virtual void ComputeNDof();
 
  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatMatrixFixWidth<2> shape) const;
  
  /// compute Curl of shape 
  //virtual void CalCurlShape (const IntegrationPoint & ip, 
  //		     FlatMatrixFixWidth<1> curlshape) const;
  
};


///
template <class T_ORTHOPOL> 
class HCurlHighOrderTet : public HCurlHighOrderFiniteElement<3>
{
  typedef VertexExtensionOptimal<3> T_VERTEXSHAPES;
  typedef TetShapesFaceLegendre T_FACESHAPES; 
  typedef TetShapesInnerLegendre T_INNERSHAPES; 

public:
  HCurlHighOrderTet (int aorder);

  virtual void ComputeNDof();
  virtual void GetInternalDofs (ARRAY<int> & idofs) const;

  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatMatrixFixWidth<3> shape) const;
  
  ///compute Curl of shape 
  virtual void CalcCurlShape (const IntegrationPoint & ip, 
			      FlatMatrixFixWidth<3> shape) const;
};

///
template <class T_ORTHOPOL>
class HCurlHighOrderHex : public HCurlHighOrderFiniteElement<3>
{
public:

  HCurlHighOrderHex (int aorder);
  virtual void ComputeNDof();
 
  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatMatrixFixWidth<3> shape) const;

  /// compute Curl of shape 
  virtual void CalcCurlShape (const IntegrationPoint & ip, 
			      FlatMatrixFixWidth<3> curlshape) const;
};

///
template <class T_ORTHOPOL> 
class HCurlHighOrderPrism : public HCurlHighOrderFiniteElement<3>
{
  typedef TrigShapesInnerLegendre T_TRIGFACESHAPES;

public:
  HCurlHighOrderPrism (int aorder);
  virtual void ComputeNDof();

  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatMatrixFixWidth<3> shape) const;
  /// compute curl of shape
  virtual void CalcCurlShape (const IntegrationPoint & ip, 
			      FlatMatrixFixWidth<3> shape) const;
  
  
};

#endif

