#ifndef FILE_HCURLHOFESPACE
#define FILE_HCURLHOFESPACE

/*********************************************************************/
/* File:   hcurlhofespace.hpp                                           */
/* Author: Sabine Zaglmayr                                                     */
/* Date:   20. Maerz 2003                                             */
/*********************************************************************/

/**
   HCurl High Order Finite Element Space
*/


class HCurlHighOrderFESpace : public FESpace
{
private:
  
  // Level
  int level;
  // Number of Edges
  int ned;
  // Number of Faces
  int nfa;
  // Number of Elements
  int nel;
  // Number of Vertex
  int nv;

  ARRAY<int> first_edge_dof;
  ARRAY<int> first_inner_dof;
  ARRAY<int> first_face_dof; 

  int fn; 
  /// relative order to mesh-order
  int rel_order; 

  ARRAY<int> order_edge;
  ARRAY<int> order_face;
  ARRAY<int> order_inner;
  ARRAY<int> usegrad_edge; 
  ARRAY<int> usegrad_face; 
  ARRAY<int> usegrad_cell; 

  BitArray gradientdomains;

  bool usegrad;  
  
  int ndof;


  Flags flags; 
  int smoother; 


public:

  HCurlHighOrderFESpace (const MeshAccess & ama, const Flags & flags);
  ///
  virtual ~HCurlHighOrderFESpace ();

  static FESpace * Create (const MeshAccess & ma, const Flags & flags);

  virtual string GetClassName () const
  {
    return "HCurlHighOrderFESpace";
  }

  ///
  virtual void Update();
  ///
  virtual int GetNDof () const;
  ///
  virtual const FiniteElement & GetFE (int elnr, LocalHeap & lh) const;
  ///
  virtual const FiniteElement & GetSFE (int selnr, LocalHeap & lh) const;
  ///
  virtual void GetDofNrs (int elnr, ARRAY<int> & dnums) const;
  ///
  virtual void GetExternalDofNrs (int elnr, ARRAY<int> & dnums) const;
  ///
  virtual void GetSDofNrs (int selnr, ARRAY<int> & dnums) const;
  ///
  virtual Table<int> * CreateSmoothingBlocks ( int type = 0) const;
  
  //virtual BitArray * CreateIntermediatePlanes (int type = 0) const;
  ///
  virtual ARRAY<int> * CreateDirectSolverClusters (int type) const;
  ///
  SparseMatrix<double> * CreateGradient() const; 
 
  int GetFirstEdgeDof(int e){ return first_edge_dof[e]; }; 
  int GetFirstFaceDof(int f){ return first_face_dof[f]; }; 
  int GetFirstCellDof(int c){ return first_inner_dof[c]; }; 

};

#endif

