#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <netdude/nd_debug.h>
#include <netdude/nd_macros.h>
#include "nd_ip.h"
#include "nd_ipfrag.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"


void
on_ip_frag1_spinbutton_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ND_FragData *data;
  int offset;

  data = gtk_object_get_data(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(editable))), "data");
  offset = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));
  nd_ip_frag_adjust(data, offset, 0);

  return;
  TOUCH(user_data);
}


void
on_ip_frag2_spinbutton_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ND_FragData *data;
  int offset;

  data = gtk_object_get_data(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(editable))), "data");
  offset = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));
  nd_ip_frag_adjust(data, offset, 1);
  
  return;
  TOUCH(user_data);
}


void
on_ip_frag_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  ND_FragData *data;

  data = gtk_object_get_data(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(button))), "data");
  nd_ip_frag_apply(data);
  
  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
on_ip_frag_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  ND_FragData *data;

  data = gtk_object_get_data(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(button))), "data");
  nd_ip_frag_cancel(data
);  

  return;
  TOUCH(button);
  TOUCH(user_data);
}

