/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.xml.jaxb.ui;

import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.xml.jaxb.util.FileSysUtil;
import org.netbeans.modules.xml.jaxb.util.JAXBWizModuleConstants;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;

/**
 *
 * @author  gpatil
 */
public class JAXBBindingInfoPnl extends javax.swing.JPanel 
        implements DocumentListener{

    /** Creates new form JAXBBindingInfoPnl */
    public JAXBBindingInfoPnl(JAXBWizBindingCfgPanel parent) {
        this.wizPanel = parent;
        initComponents();
        initComponentsCustom();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        schemaSource = new javax.swing.ButtonGroup();
        lblSchemaName = new javax.swing.JLabel();
        lblPrjName = new javax.swing.JLabel();
        lblSchemaFile = new javax.swing.JLabel();
        rdoSelectFromFileSys = new javax.swing.JRadioButton();
        txtSchemaName = new javax.swing.JTextField();
        txtPrjName = new javax.swing.JTextField();
        txtFilePath = new javax.swing.JTextField();
        btnBrowseFile = new javax.swing.JButton();
        rdoSelectURL = new javax.swing.JRadioButton();
        txtURL = new javax.swing.JTextField();
        lblPackageName = new javax.swing.JLabel();
        txtPackageName = new javax.swing.JTextField();
        lblOptions = new javax.swing.JLabel();
        lblSchemaType = new javax.swing.JLabel();
        cmbSchemaType = new javax.swing.JComboBox();
        jSeparator1 = new javax.swing.JSeparator();
        chkbxUseBindingFile = new javax.swing.JCheckBox();
        chkbxUseCatalogFile = new javax.swing.JCheckBox();
        chkbxUseExtension = new javax.swing.JCheckBox();
        btnSelectBindingFile = new javax.swing.JButton();
        cmbBindingFiles = new javax.swing.JComboBox();
        txtCatalogFile = new javax.swing.JTextField();
        btnBrowseCatalogFile = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        lblSchemaName.setLabelFor(txtSchemaName);
        org.openide.awt.Mnemonics.setLocalizedText(lblSchemaName, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_SchemaName")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(lblSchemaName, gridBagConstraints);
        lblSchemaName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "A11Y_Desc_BindingName")); // NOI18N

        lblPrjName.setLabelFor(txtPrjName);
        lblPrjName.setText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_Project")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(lblPrjName, gridBagConstraints);
        lblPrjName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "A11Y_Desc_Lbl_Project")); // NOI18N

        lblSchemaFile.setText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_SchamaFile")); // NOI18N
        lblSchemaFile.setToolTipText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "TTP_SchemaLoc")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(lblSchemaFile, gridBagConstraints);

        schemaSource.add(rdoSelectFromFileSys);
        rdoSelectFromFileSys.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(rdoSelectFromFileSys, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_SelectFromLocalFileSystem")); // NOI18N
        rdoSelectFromFileSys.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        rdoSelectFromFileSys.setMargin(new java.awt.Insets(0, 0, 0, 0));
        rdoSelectFromFileSys.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectionHandler(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 0);
        add(rdoSelectFromFileSys, gridBagConstraints);
        rdoSelectFromFileSys.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASN_rdb_SelectFromLocalFileSys")); // NOI18N
        rdoSelectFromFileSys.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_SelectLocal")); // NOI18N

        txtSchemaName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fireChangeEvent(evt);
            }
        });
        txtSchemaName.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                JAXBBindingInfoPnl.this.focusLost(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        add(txtSchemaName, gridBagConstraints);
        txtSchemaName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "A11Y_Desc_BindingNameTxt")); // NOI18N

        txtPrjName.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        add(txtPrjName, gridBagConstraints);
        txtPrjName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "A11Y_Desc_txt_Project")); // NOI18N

        txtFilePath.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                JAXBBindingInfoPnl.this.focusLost(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 35, 5, 0);
        add(txtFilePath, gridBagConstraints);
        txtFilePath.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASN_txt_LocalSchema")); // NOI18N
        txtFilePath.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_txt_LocalSchemaPath")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btnBrowseFile, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_Browse")); // NOI18N
        btnBrowseFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectionHandler(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        add(btnBrowseFile, gridBagConstraints);
        btnBrowseFile.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASN_btnBrowseSchema")); // NOI18N
        btnBrowseFile.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_BrowseLocalSchema")); // NOI18N

        schemaSource.add(rdoSelectURL);
        org.openide.awt.Mnemonics.setLocalizedText(rdoSelectURL, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_SelectFromURL")); // NOI18N
        rdoSelectURL.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        rdoSelectURL.setMargin(new java.awt.Insets(0, 0, 0, 0));
        rdoSelectURL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectionHandler(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 0);
        add(rdoSelectURL, gridBagConstraints);
        rdoSelectURL.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_SelectURL")); // NOI18N

        txtURL.setEditable(false);
        txtURL.setText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_URL_Filler")); // NOI18N
        txtURL.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                JAXBBindingInfoPnl.this.focusLost(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 35, 5, 5);
        add(txtURL, gridBagConstraints);
        txtURL.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASN_txt_URL")); // NOI18N
        txtURL.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_txt_SchemaURL")); // NOI18N

        lblPackageName.setLabelFor(txtPackageName);
        org.openide.awt.Mnemonics.setLocalizedText(lblPackageName, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_PackageName")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(lblPackageName, gridBagConstraints);
        lblPackageName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_lbl_package_name")); // NOI18N

        txtPackageName.setToolTipText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "TTP_PackageName")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        add(txtPackageName, gridBagConstraints);
        txtPackageName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_txt_PackageName")); // NOI18N

        lblOptions.setText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_Options")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        add(lblOptions, gridBagConstraints);
        lblOptions.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_CompileOoptions")); // NOI18N

        lblSchemaType.setLabelFor(cmbSchemaType);
        org.openide.awt.Mnemonics.setLocalizedText(lblSchemaType, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_SchemaType")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(lblSchemaType, gridBagConstraints);
        lblSchemaType.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_lbl_SchemaType")); // NOI18N

        cmbSchemaType.setModel(getSchemaTypeComboBoxModel());
        cmbSchemaType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                schemaTypeChangeHandler(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        add(cmbSchemaType, gridBagConstraints);
        cmbSchemaType.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_cmb_SchemaType")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        add(jSeparator1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(chkbxUseBindingFile, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_UseBindingFile")); // NOI18N
        chkbxUseBindingFile.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkbxUseBindingFile.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkbxUseBindingFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectionHandler(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        add(chkbxUseBindingFile, gridBagConstraints);
        chkbxUseBindingFile.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_chkbx_UseBindingFiles")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(chkbxUseCatalogFile, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_UseCatalogFile")); // NOI18N
        chkbxUseCatalogFile.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkbxUseCatalogFile.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkbxUseCatalogFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectionHandler(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        add(chkbxUseCatalogFile, gridBagConstraints);
        chkbxUseCatalogFile.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_chkbx_UseCatalog")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(chkbxUseExtension, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_UseExtension")); // NOI18N
        chkbxUseExtension.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkbxUseExtension.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkbxUseExtension.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectionHandler(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        add(chkbxUseExtension, gridBagConstraints);
        chkbxUseExtension.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_chkbxUseXtension")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btnSelectBindingFile, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_Configure")); // NOI18N
        btnSelectBindingFile.setEnabled(false);
        btnSelectBindingFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectionHandler(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        add(btnSelectBindingFile, gridBagConstraints);
        btnSelectBindingFile.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_btn_Configure")); // NOI18N

        cmbBindingFiles.setModel(getBindingFilesComboBoxModel());
        cmbBindingFiles.setEnabled(false);
        cmbBindingFiles.setPreferredSize(new java.awt.Dimension(275, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        add(cmbBindingFiles, gridBagConstraints);
        cmbBindingFiles.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASN_cmb_importedBindingFiles")); // NOI18N
        cmbBindingFiles.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_cmb_ImportedBindingFiles")); // NOI18N

        txtCatalogFile.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        add(txtCatalogFile, gridBagConstraints);
        txtCatalogFile.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASN_Catalog")); // NOI18N
        txtCatalogFile.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "asd_Catalog")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btnBrowseCatalogFile, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_BrowseCatalog")); // NOI18N
        btnBrowseCatalogFile.setEnabled(false);
        btnBrowseCatalogFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSelectionHandler(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        add(btnBrowseCatalogFile, gridBagConstraints);
        btnBrowseCatalogFile.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "ASD_btnBrowseCatalog")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

private void focusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_focusLost
    if (evt.getSource() == this.txtFilePath){
        String str = this.txtFilePath.getText();
        if ((this.prevSchemaPath != null) && (this.prevSchemaPath.equals(str))){
            //Field has not changed, skip guessing 
        } else {
            if ((str != null) && (!"".equals(str.trim()))){            
                guessSchemaType(str);
                this.prevSchemaPath = str;
                str = relativizePath(str);
                if ((str != null) && (!"".equals(str.trim()))){
                    this.txtFilePath.setText(str);
                }
            }
        }        
    }
    
    if (evt.getSource() == this.txtURL){
        String str = this.txtURL.getText();
        if ((this.prevSchemaURL != null) && (this.prevSchemaURL.equals(str))){
            //Field has not changed, skip guessing 
        } else {
            guessSchemaType(str);
            this.prevSchemaURL = str;
        }        
    }
    
    this.wizPanel.fireChangeEvent();
}//GEN-LAST:event_focusLost

private void fireChangeEvent(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fireChangeEvent
    this.wizPanel.fireChangeEvent();
}//GEN-LAST:event_fireChangeEvent

    private String relativizePath(String absPath){
        File absFile = new File(absPath);
        absFile = FileUtil.normalizeFile(absFile);
        return FileSysUtil.Absolute2RelativePathStr(this.projDir, absFile);
    }
    
    private String getMsg(String msgKey){
        return org.openide.util.NbBundle.getMessage(
                JAXBBindingInfoPnl.class, msgKey);
    }

    private String getMsg(String msgKey, Object params){
        return org.openide.util.NbBundle.getMessage(
                JAXBBindingInfoPnl.class, msgKey, params);
    }
    
    private void initComponentsCustom(){
        chkbxNv = new javax.swing.JCheckBox();
        chkbxReadOnly = new javax.swing.JCheckBox();
        chkbxNpa = new javax.swing.JCheckBox();
        chkbxVerbose = new javax.swing.JCheckBox();
        chkbxQuiet = new javax.swing.JCheckBox();

        this.chkbxNv.setMargin(new Insets(5, 5, 5, 5));
        this.chkbxReadOnly.setMargin(new Insets(5, 5, 5, 5));
        this.chkbxNpa.setMargin(new Insets(5, 5, 5, 5));        
        this.chkbxVerbose.setMargin(new Insets(5, 5, 5, 5));
        this.chkbxQuiet.setMargin(new Insets(5, 5, 5, 5));        

        //chkbxNv.setText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_NV")); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(chkbxNv, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_NV")); // NOI18N        
        chkbxNv.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

        //chkbxReadOnly.setText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_ReadOnly")); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(chkbxReadOnly, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_ReadOnly")); // NOI18N        
        chkbxReadOnly.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

        //chkbxNpa.setText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_NPA")); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(chkbxNpa, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_NPA")); // NOI18N        
        chkbxNpa.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));


        //chkbxVerbose.setText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_Verbose")); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(chkbxVerbose, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_Verbose")); // NOI18N        
        chkbxVerbose.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

        chkbxVerbose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fireChangeEvent(evt);
            }
        });

	//chkbxQuiet.setText(org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_Quiet")); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(chkbxQuiet, org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, "LBL_Quiet")); // NOI18N        
	chkbxQuiet.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
	chkbxQuiet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fireChangeEvent(evt);
            }
	});

        this.optionsBox = Box.createHorizontalBox();
        this.optionsBox.add(this.chkbxNv);
        this.optionsBox.add(Box.createHorizontalStrut(10));
        this.optionsBox.add(this.chkbxReadOnly);
        this.optionsBox.add(Box.createHorizontalStrut(10));
        this.optionsBox.add(this.chkbxNpa);
        this.optionsBox.add(Box.createHorizontalStrut(10));
        this.optionsBox.add(this.chkbxVerbose);
        this.optionsBox.add(Box.createHorizontalStrut(10));
        this.optionsBox.add(this.chkbxQuiet);
        this.optionsBox.add(Box.createHorizontalStrut(10));
        
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);    
        add(this.optionsBox, gridBagConstraints);
    
        // set tooltips.
        this.chkbxNv.setToolTipText(getMsg("TT_NV")); //NOI18N
        this.chkbxReadOnly.setToolTipText(getMsg("TT_ReadOnly")); //NOI18N
        this.chkbxNpa.setToolTipText(getMsg("TT_NPA")); //NOI18N
        this.chkbxVerbose.setToolTipText(getMsg("TT_Verbose")); //NOI18N
        this.chkbxQuiet.setToolTipText(getMsg("TT_Quiet")); //NOI18N

        this.chkbxUseExtension.setToolTipText(getMsg("TT_Extension")); //NOI18N
        this.chkbxUseBindingFile.setToolTipText(getMsg("TT_chkbxBindingFile"));//NOI18N
        this.chkbxUseCatalogFile.setToolTipText(getMsg("TT_chkbxCatalogFile"));//NOI18N
        this.cmbSchemaType.setToolTipText(getMsg("TT_SchemaType")); //NOI18N
        this.txtPackageName.setToolTipText(getMsg("TT_PackageName")); //NOI18N
        this.txtURL.setToolTipText(getMsg("TT_URL")); //NOI18N
        this.txtFilePath.setToolTipText(getMsg("TT_LocalSchemaFile")); //NOI18N
        this.txtSchemaName.setToolTipText(getMsg("TT_SchemaName" )); //NOI18N
        
        this.txtSchemaName.getDocument().addDocumentListener(this);
        this.txtFilePath.getDocument().addDocumentListener(this);
        this.txtURL.getDocument().addDocumentListener(this);
    }

    private void localFileSelected(boolean selected){
        this.txtFilePath.setEnabled(selected);
        this.txtFilePath.setEditable(selected);
        this.txtURL.setEnabled(!selected);
        this.txtURL.setEditable(!selected);
        this.btnBrowseFile.setEnabled(selected);
    }

    private void useBindingFileSelection(boolean selected){
        this.cmbBindingFiles.setEnabled(selected);
        this.btnSelectBindingFile.setEnabled(selected);
    }

    private void useCatalogFileSelection(boolean selected){
        this.txtCatalogFile.setEnabled(selected);
        this.txtCatalogFile.setEditable(selected);
        this.btnBrowseCatalogFile.setEnabled(selected);
    }

    private void btnSelectionHandler(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSelectionHandler
        if (evt.getSource() == this.rdoSelectFromFileSys){
            if (this.rdoSelectFromFileSys.isSelected()){
                localFileSelected(true);
            }
        }

        if (evt.getSource() == this.rdoSelectURL){
            if (this.rdoSelectURL.isSelected()){
                //urlSelected();
                localFileSelected(false);
            }
        }

        if (evt.getSource() == this.chkbxUseBindingFile){
            if (this.chkbxUseBindingFile.isSelected()){
                useBindingFileSelection(true);
            } else {
                useBindingFileSelection(false);
            }
        }

        if (evt.getSource() == this.chkbxUseCatalogFile){
            if (this.chkbxUseCatalogFile.isSelected()){
                useCatalogFileSelection(true);
            } else {
                useCatalogFileSelection(false);
            }
        }

        if (evt.getSource() == this.btnBrowseFile){
            String filePath = selectFileFromFileSystem(this,
                    this.projDir,
                    JAXBWizModuleConstants.LAST_BROWSED_SCHEMA_DIR);
            if (filePath != null){
                this.txtFilePath.setText(filePath);

                if ((this.prevSchemaPath != null) 
                        && (this.prevSchemaPath.equals(filePath))){
                    //Field has not changed, skip guessing 
                } else {
                    guessSchemaType(filePath);
                    this.prevSchemaPath = filePath;
                }                        
            }
        }

        if (evt.getSource() == this.btnSelectBindingFile){
            Vector<String> files = new Vector<String>();
            files.addAll(getBindingFiles());
            FileListPanel flp = new FileListPanel();
            flp.setProjDir(this.projDir);
            flp.setFiles(files);
            DialogDescriptor dd = new DialogDescriptor(flp, 
                    getMsg("LBL_DD_TTL_BindingFile")); //NOI18N
            Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
            dlg.setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION){
                files.removeAllElements();
                files.addAll(flp.getFiles());
                DefaultComboBoxModel model = new DefaultComboBoxModel(files);
                this.cmbBindingFiles.setModel(model);
            }
        }

        if (evt.getSource() == this.btnBrowseCatalogFile){
            String filePath = selectFileFromFileSystem(this,
                    this.projDir,
                    JAXBWizModuleConstants.LAST_BROWSED_SCHEMA_DIR);
            if (filePath != null){
                this.txtCatalogFile.setText(filePath);
            }
        }

        this.wizPanel.fireChangeEvent();
}//GEN-LAST:event_btnSelectionHandler

    private void schemaTypeChangeHandler(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_schemaTypeChangeHandler
        if (!this.isInitializing()){
            if (!SCHEMA_TYPE_XML.equals(this.cmbSchemaType.getSelectedItem())){
                NotifyDescriptor nd = new NotifyDescriptor.Message(
                        getMsg("MSG_SchemaTypeNotSupported", // NOI18N
                        this.cmbSchemaType.getSelectedItem()),
                        NotifyDescriptor.INFORMATION_MESSAGE);
                DialogDisplayer.getDefault().notify(nd);
            }
        }
    }//GEN-LAST:event_schemaTypeChangeHandler

    private void guessSchemaType(String str){
        if (str != null){
            str = str.toLowerCase();
            if (str.endsWith("wsdl")){ //NOI18N
                this.cmbSchemaType.setSelectedItem(SCHEMA_TYPE_WSDL);
            }

            if (str.endsWith("xsd")){ //NOI18N
                this.cmbSchemaType.setSelectedItem(SCHEMA_TYPE_XML);
            }

            if (str.endsWith("dtd")){ //NOI18N
                this.cmbSchemaType.setSelectedItem(SCHEMA_TYPE_DTD);
            }

            if ( str.endsWith("rng") || str.endsWith("relaxng")){ //NOI18N
                this.cmbSchemaType.setSelectedItem(SCHEMA_TYPE_RELAXNG);
            }                
        }        
    }
    


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnBrowseCatalogFile;
    private javax.swing.JButton btnBrowseFile;
    private javax.swing.JButton btnSelectBindingFile;
    private javax.swing.JCheckBox chkbxUseBindingFile;
    private javax.swing.JCheckBox chkbxUseCatalogFile;
    private javax.swing.JCheckBox chkbxUseExtension;
    private javax.swing.JComboBox cmbBindingFiles;
    private javax.swing.JComboBox cmbSchemaType;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel lblOptions;
    private javax.swing.JLabel lblPackageName;
    private javax.swing.JLabel lblPrjName;
    private javax.swing.JLabel lblSchemaFile;
    private javax.swing.JLabel lblSchemaName;
    private javax.swing.JLabel lblSchemaType;
    private javax.swing.JRadioButton rdoSelectFromFileSys;
    private javax.swing.JRadioButton rdoSelectURL;
    private javax.swing.ButtonGroup schemaSource;
    private javax.swing.JTextField txtCatalogFile;
    private javax.swing.JTextField txtFilePath;
    private javax.swing.JTextField txtPackageName;
    private javax.swing.JTextField txtPrjName;
    private javax.swing.JTextField txtSchemaName;
    private javax.swing.JTextField txtURL;
    // End of variables declaration//GEN-END:variables


    // Custom code
    // Custom UI components
    private javax.swing.JCheckBox chkbxNpa;
    private javax.swing.JCheckBox chkbxNv;
    private javax.swing.JCheckBox chkbxQuiet;
    private javax.swing.JCheckBox chkbxReadOnly;
    private javax.swing.JCheckBox chkbxVerbose;
    private javax.swing.Box optionsBox;

    // Custom variables
    private static java.util.Vector<ComboElement<String, String>> SCHEMA_TYPES = null;
    private static ComboElement<String, String> SCHEMA_TYPE_WSDL = 
            new JAXBBindingInfoPnl.ComboElement<String, String>(getMessage(
            "LBL_" + JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_WSDL), //NOI18N
            JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_WSDL) ;
    private static ComboElement<String, String> SCHEMA_TYPE_XML = 
            new JAXBBindingInfoPnl.ComboElement<String, String>(getMessage(
            "LBL_" + JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_XML_SCHEMA), //NOI18N
            JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_XML_SCHEMA);
    private static ComboElement<String, String> SCHEMA_TYPE_RELAXNG = 
            new JAXBBindingInfoPnl.ComboElement<String, String>(getMessage(
            "LBL_" + JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_RELAX_NG), //NOI18N
            JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_RELAX_NG);
    private static ComboElement<String, String> SCHEMA_TYPE_RELAXNG_CMPCT = 
            new JAXBBindingInfoPnl.ComboElement<String, String>(getMessage(
            "LBL_" + JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_RELAX_NG_COMPACT), //NOI18N
            JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_RELAX_NG_COMPACT);
    private static ComboElement<String, String> SCHEMA_TYPE_DTD = 
            new JAXBBindingInfoPnl.ComboElement<String, String>(getMessage(
            "LBL_" + JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_DTD), //NOI18N
            JAXBWizModuleConstants.JAXB_SCHEMA_TYPE_DTD) ;
    
    private static java.util.Map<String, File> LAST_BROWSED_DIRS = new java.util.HashMap<String, File>();
    private JAXBWizBindingCfgPanel wizPanel = null;
    private Vector<String> origBindingFiles = new Vector<String>();
    private String prevSchemaPath = null;
    private String prevSchemaURL = null;    
    private File projDir = null;
    private boolean initializing = false;
            
    private static String getMessage(String key){
        return org.openide.util.NbBundle.getMessage(JAXBBindingInfoPnl.class, key);
    }

    private static synchronized java.util.Vector<ComboElement<String, String>>
            getSchemaTypes(){
        if (SCHEMA_TYPES == null){
            SCHEMA_TYPES = new java.util.Vector<ComboElement<String, String>>();
            SCHEMA_TYPES.add(SCHEMA_TYPE_XML);
            SCHEMA_TYPES.add(SCHEMA_TYPE_RELAXNG);
            SCHEMA_TYPES.add(SCHEMA_TYPE_RELAXNG_CMPCT);
            SCHEMA_TYPES.add(SCHEMA_TYPE_DTD);
            SCHEMA_TYPES.add(SCHEMA_TYPE_WSDL);
        }
        return SCHEMA_TYPES;
    }

    private static synchronized File getLastBrowsedDir(String type){
        return LAST_BROWSED_DIRS.get(type);
    }

    private static synchronized void setLastBrowsedDir(String type, File dir){
        LAST_BROWSED_DIRS.put(type, dir);
    }

    protected static String selectFileFromFileSystem(JPanel panel,
            File projDir,
            String type){
        File file = null;
        String ret = null;
        File lastBrowsed = getLastBrowsedDir(type);
        JFileChooser jfc = new JFileChooser();
        if (lastBrowsed != null){
            jfc.setCurrentDirectory(lastBrowsed);
        }

        jfc.setMultiSelectionEnabled(false);
        jfc.setFileSelectionMode( JFileChooser.FILES_ONLY  );
        int iRt = jfc.showOpenDialog(panel);
        if ( iRt == JFileChooser.APPROVE_OPTION ) {
            file = jfc.getSelectedFile();
            file = FileUtil.normalizeFile(file);
        }
        File currDir = jfc.getCurrentDirectory();
        if (currDir != null){
            setLastBrowsedDir(type, currDir);
        }
        
        if (file != null){
            String absPath = file.getAbsolutePath();
            ret = FileSysUtil.Absolute2RelativePathStr(projDir, 
                    file.getAbsoluteFile());
            if (ret == null){
                //This can happen in Windows where Project and Files are in 
                // different drives.
                ret = absPath;
            }
        }        

        return ret;
    }

    private synchronized boolean isInitializing(){
        return this.initializing;
    }

    public synchronized void setInitializing(boolean ini){
        this.initializing = ini;
    }
    
    private javax.swing.DefaultComboBoxModel getSchemaTypeComboBoxModel(){
        javax.swing.DefaultComboBoxModel ret =
                new javax.swing.DefaultComboBoxModel(getSchemaTypes());
        return ret;
    }

    private javax.swing.DefaultComboBoxModel getBindingFilesComboBoxModel(){
        javax.swing.DefaultComboBoxModel ret =
                new javax.swing.DefaultComboBoxModel(this.origBindingFiles);
        return ret;
    }

    // Getter and Setter for UI clients - start
    public void setSchemaName(String name){
        this.txtSchemaName.setText(name);
    }

    public void setProjectName(String pn){
        this.txtPrjName.setText(pn);
    }

    public void setProjectDir(File pdir){
        this.projDir = pdir;
    }
    
    public void setLocalSchemaFile(String fileLoc){
        this.txtFilePath.setText(fileLoc);
    }

    public void setSchemaURL(String url){
        this.txtURL.setText(url);
        this.rdoSelectURL.setSelected(true);
        this.prevSchemaURL = url;
        localFileSelected(false);
    }

    public void setPackageName(String pkgName){
        this.txtPackageName.setText(pkgName);
    }

    public void setOptions(java.util.Map<String, Boolean> options){
        if (Boolean.TRUE.equals(options.get(
                JAXBWizModuleConstants.JAXB_OPTION_NV))){
            this.chkbxNv.setSelected(true);
        }

        if (Boolean.TRUE.equals(options.get(
                JAXBWizModuleConstants.JAXB_OPTION_READ_ONLY))){
            this.chkbxReadOnly.setSelected(true);
        }

        if (Boolean.TRUE.equals(options.get(
                JAXBWizModuleConstants.JAXB_OPTION_NPA))){
            this.chkbxNpa.setSelected(true);
        }

        if (Boolean.TRUE.equals(options.get(
                JAXBWizModuleConstants.JAXB_OPTION_VERBOSE))){
            this.chkbxVerbose.setSelected(true);
        }

        if (Boolean.TRUE.equals(options.get(
                JAXBWizModuleConstants.JAXB_OPTION_QUIET))){
            this.chkbxQuiet.setSelected(true);
        }

        if (Boolean.TRUE.equals(options.get(
                JAXBWizModuleConstants.JAXB_OPTION_EXTENSION))){
            this.chkbxUseExtension.setSelected(true);
        }
    }

    public void setSchemaType(String value){
        java.util.Vector<ComboElement<String, String>> st = getSchemaTypes();
        ComboElement<String, String> ce =
                                new ComboElement<String, String>(value, value);
        int index = st.indexOf(ce);
        this.cmbSchemaType.setSelectedIndex(index);
    }

    public void setSchemaFile(String schemaFile){
        this.txtFilePath.setText(schemaFile);
        this.prevSchemaPath = schemaFile;
    }

    public void setBindingFiles(List<String> files){
        if ((files != null) && (files.size() > 0)){
            this.origBindingFiles.removeAllElements();
            this.origBindingFiles.addAll(files);
            this.cmbBindingFiles.setModel(this.getBindingFilesComboBoxModel());
            this.chkbxUseBindingFile.setSelected(true);
            useBindingFileSelection(true);
        }
    }

    public void setCatalogFile(String file){
        if (file != null){
            this.txtCatalogFile.setText(file);
            this.chkbxUseCatalogFile.setSelected(true);
            useCatalogFileSelection(true);
        }
    }

    public String getSchemaName(){
        return this.txtSchemaName.getText();
    }

    public String getSchemaFile(){
        String ret = null;
        if (this.rdoSelectFromFileSys.isSelected()){
            ret = this.txtFilePath.getText();
        }
        return ret;
    }

    public boolean isFromURLSelected(){
        return this.rdoSelectURL.isSelected();
    }
    
    public boolean isFromFSSelected(){
        return this.rdoSelectFromFileSys.isSelected();
    }
    
    public String getSchemaURL(){
        String ret = null;
        if (this.rdoSelectURL.isSelected()){
            ret = this.txtURL.getText();
        }
        return ret;
    }

    public String getPackageName(){
        return this.txtPackageName.getText();
    }

    public  java.util.Map<String, Boolean> getOptions(){
        java.util.Map<String, Boolean> ret =
                new java.util.HashMap<String, Boolean>();
        if (this.chkbxNv.isSelected()){
            ret.put(JAXBWizModuleConstants.JAXB_OPTION_NV, Boolean.TRUE);
        }

        if (this.chkbxReadOnly.isSelected()){
            ret.put(JAXBWizModuleConstants.JAXB_OPTION_READ_ONLY, Boolean.TRUE);
        }

        if (this.chkbxNpa.isSelected()){
            ret.put(JAXBWizModuleConstants.JAXB_OPTION_NPA, Boolean.TRUE);
        }

        if (this.chkbxVerbose.isSelected()){
            ret.put(JAXBWizModuleConstants.JAXB_OPTION_VERBOSE, Boolean.TRUE);
        }

        if (this.chkbxQuiet.isSelected()){
            ret.put(JAXBWizModuleConstants.JAXB_OPTION_QUIET, Boolean.TRUE);
        }

        if (this.chkbxUseExtension.isSelected()){
            ret.put(JAXBWizModuleConstants.JAXB_OPTION_EXTENSION, Boolean.TRUE);
        }

        return ret;
    }

    public String getSchemaType(){
        String ret = null;
        ComboElement<String, String> elem = (ComboElement<String, String>)
                this.cmbSchemaType.getSelectedItem();
        if (elem != null){
            ret = elem.getValue();
        }
        return ret;
    }

    public List<String> getBindingFiles(){
        if (this.chkbxUseBindingFile.isSelected()){
            List<String> files = new ArrayList<String>();
            ComboBoxModel model = this.cmbBindingFiles.getModel();
            int i = model.getSize();

            for (int j=0; j < i; j++ ){
                files.add((String) model.getElementAt(j));
            }
            return files;
        } else {
            return null;
        }
    }


    public String getCatalogFile(){
        if (this.chkbxUseCatalogFile.isSelected()){
            return this.txtCatalogFile.getText();
        } else {
            return null;
        }
    }

    // Getter and Setter for UI clients - end
    private boolean isEmpty(String str){
        boolean ret = true;
        if ((str != null) && (!"".equals(str.trim()))){ //NOI18N
            ret = false;
        }
        return ret;
    }

    public static class  ComboElement<T1, T2> {
        private T1 display;
        private T2 value;
        int hash = -1 ;

        ComboElement(T1 d, T2 v){
            this.display = d;
            this.value = v;
        }

        public T2 getValue(){
            return this.value;
        }

        @Override
        public String toString(){
            return this.display.toString();
        }

        @Override
        public int hashCode() {
            // Only consider value
            if (hash == -1){
                hash = this.value.hashCode();
            }
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj){
                return true;
            }

            // Only consider value
            boolean ret = false;
            if (obj instanceof ComboElement){
                ComboElement other = (ComboElement) obj;
                if (other.getValue().equals(this.value)){
                    //if (other.display.equals(this.display)){
                        ret = true;
                    //}
                }
            }
            return ret;
        }
    }

    // DocumentListener interface methods -begin
    private void validateDocListenerObjects(DocumentEvent evt){
        if ((this.txtSchemaName.getDocument() == evt.getDocument()) ||
             (this.txtFilePath.getDocument() == evt.getDocument()) ||
             (this.txtURL.getDocument() == evt.getDocument()) ) {
            this.fireChangeEvent(null);
        }        
    }
    
    public void insertUpdate(DocumentEvent evt) {
        validateDocListenerObjects(evt);
    }

    public void removeUpdate(DocumentEvent evt) {
        validateDocListenerObjects(evt);
    }

    public void changedUpdate(DocumentEvent evt) {
        validateDocListenerObjects(evt);    
    }
    // DocumentListener interface methods -begin
}
