/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xml.catalog.impl.sun;

import java.beans.*;
import java.io.File;
import java.net.MalformedURLException;
import org.openide.util.NbBundle;

/**
 * Catalog customizer. It allows to customize catalog location and
 * preferences.
 *
 * @author  Petr Kuzel
 * @version
 */
public class CatalogCustomizer extends javax.swing.JPanel implements Customizer {

    /** Serial Version UID */
    private static final long serialVersionUID =-1437233290256708364L;

    Catalog model = null;

    /** Creates new customizer XCatalogCustomizer */
    public CatalogCustomizer() {
        initComponents ();
        
        // A11Y
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogCustomizer.class, "ACSD_CatalogCustomizer"));        
        
        locationLabel.setDisplayedMnemonic((NbBundle.getMessage(CatalogCustomizer.class, "CatalogCustomizer.locationLabel.mne")).charAt(0));
        locationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogCustomizer.class, "ACSD_locationTextField"));

        preferCheckBox.setMnemonic(NbBundle.getMessage(CatalogCustomizer.class, "MNE_preference").charAt(0));
        preferCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogCustomizer.class, "ACSD_preference"));
        
        selectButton.setMnemonic(NbBundle.getMessage(CatalogCustomizer.class, "MNE_file").charAt(0));
        selectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogCustomizer.class, "ACSD_file"));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        locationLabel = new javax.swing.JLabel();
        locationTextField = new javax.swing.JTextField();
        selectButton = new javax.swing.JButton();
        preferCheckBox = new javax.swing.JCheckBox();
        descTextArea = new javax.swing.JTextArea();

        setLayout(new java.awt.GridBagLayout());

        locationLabel.setLabelFor(locationTextField);
        locationLabel.setText(NbBundle.getMessage(CatalogCustomizer.class, "CatalogCustomizer.locationLabel.text")); // NOI18N
        add(locationLabel, new java.awt.GridBagConstraints());

        locationTextField.setColumns(40);
        locationTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                locationTextFieldActionPerformed(evt);
            }
        });
        locationTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                locationTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(locationTextField, gridBagConstraints);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/xml/catalog/impl/sun/Bundle"); // NOI18N
        selectButton.setText(bundle.getString("PROP_choose_file")); // NOI18N
        selectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(selectButton, gridBagConstraints);

        preferCheckBox.setText(bundle.getString("LBL_preference")); // NOI18N
        preferCheckBox.setToolTipText(NbBundle.getMessage(CatalogCustomizer.class, "HINT_pp")); // NOI18N
        preferCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                preferCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(preferCheckBox, gridBagConstraints);

        descTextArea.setColumns(40);
        descTextArea.setEditable(false);
        descTextArea.setFont(javax.swing.UIManager.getFont ("Label.font"));
        descTextArea.setForeground(new java.awt.Color(102, 102, 153));
        descTextArea.setLineWrap(true);
        descTextArea.setRows(4);
        descTextArea.setText(NbBundle.getMessage(CatalogCustomizer.class, "DESC_catalog_fmts")); // NOI18N
        descTextArea.setWrapStyleWord(true);
        descTextArea.setDisabledTextColor(javax.swing.UIManager.getColor ("Label.foreground"));
        descTextArea.setEnabled(false);
        descTextArea.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(descTextArea, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void selectButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selectButtonActionPerformed
        File f = org.netbeans.modules.xml.catalog.lib.Util.selectCatalogFile("txt xml cat catalog"); // NOI18N
        if (f == null) return;
        try {
            String location = f.toURL().toExternalForm();
            locationTextField.setText(location);
            model.setLocation(location);
        } catch (MalformedURLException ex) {
            // ignore
        }
    }//GEN-LAST:event_selectButtonActionPerformed

    private void preferCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_preferCheckBoxStateChanged
        if (model != null) model.setPreferPublic(preferCheckBox.isSelected());
    }//GEN-LAST:event_preferCheckBoxStateChanged

    //!!! find out whether action performed is not enough
    
    private void locationTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_locationTextFieldFocusLost
        //if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug("FocusLost-setting location: " + locationTextField.getText()); // NOI18N
        model.setLocation(locationTextField.getText());
    }//GEN-LAST:event_locationTextFieldFocusLost

    private void locationTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_locationTextFieldActionPerformed
        //if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug("ActionPerformed-setting location: " + locationTextField.getText()); // NOI18N
        model.setLocation(locationTextField.getText());
    }//GEN-LAST:event_locationTextFieldActionPerformed

    /**
     * Set model for this customizer.
     */
    public void setObject(java.lang.Object peer) {
        if ((peer instanceof Catalog) == false) {
            throw new IllegalArgumentException("Catalog instance expected (" + peer.getClass() + ").");  // NOI18N
        }
        
        model = (Catalog) peer;        
        locationTextField.setText(model.getLocation());
        preferCheckBox.setSelected(model.isPreferPublic());
    }    

    public void addPropertyChangeListener(java.beans.PropertyChangeListener p1) {
    }
    
    public void removePropertyChangeListener(java.beans.PropertyChangeListener p1) {
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea descTextArea;
    private javax.swing.JLabel locationLabel;
    private javax.swing.JTextField locationTextField;
    private javax.swing.JCheckBox preferCheckBox;
    private javax.swing.JButton selectButton;
    // End of variables declaration//GEN-END:variables

}
