/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model.impl;


import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.XslComponent;
import org.netbeans.modules.xslt.model.XslModel;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import junit.framework.TestCase;


/**
 * @author ads
 *
 */
public class AbstractXslTestCase extends TestCase {
    
    public static final String TEST = "test.xsl";

    public AbstractXslTestCase(String testName) {
        super(testName);
    }

    protected void tearDown() throws Exception {
        TestCatalogModel.getDefault().clearDocumentPool();
    }
    
    protected void log( String str ) {
        System.out.println( str );
    }
    
    protected Stylesheet getStyleSheet( String resourse ) {
        return getStyleSheet(resourse , false);
    }
    
    protected Stylesheet getStyleSheet( String resourse , boolean reload) {
        if ( !reload && myStylesheet != null ) {
            return myStylesheet;
        }
        try {
            XslModel model = Utils.loadXslModel( resourse , reload );
            myStylesheet = model.getStylesheet(); 
            return myStylesheet;
        }
        catch (Exception e) {
            RuntimeException exc = new RuntimeException( e );
            throw exc;
        }
    }
    
    protected String getContent( XslModel model ) {
        Document doc = (Document)model.getModelSource().getLookup().lookup( 
                Document.class );
        assert doc != null;
        String str = null ;
        try {
            str = doc.getText( 0, doc.getLength() );
        }
        catch (BadLocationException e) {
            assert false;
        }
        return str;
    }
    
    protected org.w3c.dom.Document getDOMDocument( XslModel model ) 
    {
        //model.getAccess().flush();
        
        Exception exception = null;
        try {
            String str = getContent(model);
            DocumentBuilder builder =
                DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse( new InputSource( new StringReader( str )) );
        }
        catch (ParserConfigurationException e) {
            exception = e;
        }
        catch (SAXException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        if ( exception != null ) {
            AssertionError error = new AssertionError( );
            error.initCause( exception );
            throw error;
        }
        return null;
    } 
    
    protected XslModel getModel() {
        return myStylesheet.getModel();
    }
    
    protected List<String> getChildrenTags( List<? extends XslComponent> list ){
        List<String> ret = new ArrayList<String>( list.size() );
        for (XslComponent component : list) {
            String name = component.getPeer().getNodeName();
            /*String name = component.getComponentType().toString().toLowerCase();
            assert name.indexOf( "-" )!=-1;*/
            ret.add( name );
        }
        return ret;
    }
    
    private Stylesheet myStylesheet;
    
}
