/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.xslt.model;


/**
 * The main categories of XSLT instruction are as follows:
 * </p>
 * <ul>
 * <li>
 * <p>
 * instructions that create new nodes: <code>xsl:document</code>,
 * <code>xsl:element</code>, <code>xsl:attribute</code>,
 * <code>xsl:processing-instruction</code>, <code>xsl:comment</code></a>,
 * <code>xsl:value-of</code>, <code>xsl:text</code>,
 * <code>xsl:namespace</code>;
 * </p>
 * </li>
 * <li>
 * <p>
 * an instruction that returns an arbitrary sequence by evaluating an XPath
 * expression: <code>xsl:sequence</code>;
 * </p>
 * </li>
 * <li>
 * <p>
 * instructions that cause conditional or repeated evaluation of nested
 * instructions: <code>xsl:if</code>, <code>xsl:choose</code>,
 * <code>xsl:for-each</code>, <code>xsl:for-each-group</code>;
 * </p>
 * </li>
 * <li>
 * <p>
 * instructions that invoke templates: <code>xsl:apply-templates</code>,
 * <code>xsl:apply-imports</code>, <code>xsl:call-template</code>,
 * <code>xsl:next-match</code>;
 * </p>
 * </li>
 * <li>
 * <p>
 * Instructions that declare variables: <code>xsl:variable</code>,
 * <code>xsl:param</code>;
 * </p>
 * </li>
 * <li>
 * <p>
 * other specialized instructions: <code>xsl:number</code>,
 * <code>xsl:analyze-string</code>, <code>xsl:message</code>,
 * <code>xsl:result-document</code>.
 * </p>
 * </li>
 * </ul>
 * 
 * @author ads
 */

public interface Instruction extends XslComponent, SequenceElement {

}
