/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xml.core.scenario;

import java.awt.Dialog;
import java.util.Iterator;
import org.openide.util.Lookup;
import org.openide.loaders.DataObject;
import java.util.Collection;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.DialogDisplayer;

import org.openide.util.HelpCtx;
import org.netbeans.modules.xml.api.scenario.*;
import org.openide.util.lookup.Lookups;

/**
 * A UI panel which allows the user to select a name and scenario type from
 * a list of ScenarioFactories allowed for the requesting DataObject.
 * Allowed ScenarioFactories are all registered ScenarioFactory objects
 * where the isEnabled() method returns true.
 * <p>
 * Recommended entry point is (@link #addScenario} method.
 * 
 * @author  asgeir@dimonsoftware.com
 */
public class NewScenarioPanel extends javax.swing.JPanel {
    
    private static final String FOLDER = "Plugins/XML/ScenarioFactories";// NOI18N

    /** Creates new form NewScenarioPanel */
    public NewScenarioPanel(String defaultName, DataObject dataObject) throws NoFactoriesException {
        initComponents();
        
        nameField.setText(defaultName);
        nameField.setSelectionStart(0);
        nameField.setSelectionEnd(defaultName.length());
       
        // Load the ScenarioFactories from the XML layer
        Lookup.Template template =
            new Lookup.Template(ScenarioFactory.class);
        Lookup.Result registrations = Lookups.forPath(FOLDER).lookup(template);

        // Only display enabled factories for this DataObject
        Collection allFactories = registrations.allInstances();
        Vector<ScenarioFactory> allowedFactories = new Vector<ScenarioFactory>();
        Iterator iter = allFactories.iterator();
        while(iter.hasNext()) {
            ScenarioFactory factory = (ScenarioFactory)iter.next();
            if (factory.isEnabled(dataObject)) {
                allowedFactories.add(factory);
            }
        }

        if (allowedFactories.size() == 0) {
            throw new NoFactoriesException();
        }

        typeCombo.setModel(new javax.swing.DefaultComboBoxModel(allowedFactories.toArray()));
    }
    
    /**
     * Adds a new scenario to the scenario model (pupups UI).
     * @param dataObject transformation for which is the scerio created
     * @param scenarioModel output model
     * @return Scenarion if a new scenario was added, else return <code>null</code>.
     */
    public static Scenario createScenario(DataObject dataObject, DefaultComboBoxModel scenarioModel) {
        
        // Find a unique name for the new scenario
        String defaultName = null;
        for (int nameInd = 1; defaultName == null; nameInd++) {
            defaultName = Util.THIS.getString ("NAME_Scenario_default", Integer.toString(nameInd));
            for (int ind = 0; ind < scenarioModel.getSize(); ind++) {
                if (defaultName.equals(((Scenario)scenarioModel.getElementAt(ind)).getName())) {
                    defaultName = null;
                    break;
                }
            }
        }
        
        // Create a new scenario
        NewScenarioPanel newScenarioPanel;
        try {
            newScenarioPanel = new NewScenarioPanel(defaultName, dataObject);
        } catch (NewScenarioPanel.NoFactoriesException e) {
            NotifyDescriptor nd = new NotifyDescriptor.Message (e.getMessage(), NotifyDescriptor.INFORMATION_MESSAGE);
            DialogDisplayer.getDefault().notify (nd);
            return null;
        }
        
        DialogDescriptor newDD = new DialogDescriptor
            (newScenarioPanel,
             Util.THIS.getString("NAME_New_scenario_dialog_title"), true,
             DialogDescriptor.OK_CANCEL_OPTION, DialogDescriptor.OK_OPTION,
             DialogDescriptor.BOTTOM_ALIGN,
             new HelpCtx (NewScenarioPanel.class), null);
        newDD.setClosingOptions (new Object[] { DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION });
        Dialog dialog = DialogDisplayer.getDefault().createDialog (newDD);
        dialog.show();
        
        if (newDD.getValue() == DialogDescriptor.OK_OPTION) {
            Scenario newScenario = newScenarioPanel.createScenario();
            scenarioModel.addElement(newScenario);
            return newScenario;
        }
        
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        nameField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        typeCombo = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Name:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel1, gridBagConstraints);

        nameField.setToolTipText("null");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        gridBagConstraints.weightx = 1.0;
        add(nameField, gridBagConstraints);

        jLabel2.setText("Type:");
        jLabel2.setToolTipText("null");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        gridBagConstraints.weightx = 1.0;
        add(typeCombo, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox typeCombo;
    private javax.swing.JTextField nameField;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel1;

    /** @link dependency 
     * @label looks up*/
    /*# ScenarioFactory lnkScenarioFactory; */
    // End of variables declaration//GEN-END:variables
    
    public Scenario createScenario() {
        ScenarioFactory factory = (ScenarioFactory)typeCombo.getSelectedItem();
        if (factory != null) {
            Scenario scenario =  factory.createScenario();
            scenario.setName(nameField.getText());
            return scenario;
        } else {
            return null;
        }
    }
    
    public class NoFactoriesException extends Exception {
        public NoFactoriesException() {
            super(Util.THIS.getString("MSG_no_factories"));
        }
    }
}
