/*
 * PhpLanguagePanelVisual.java
 *
 * Created on 29 Август 2007 г., 18:32
 */

package org.netbeans.modules.php.project.wizards;

import java.awt.BorderLayout;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author  avk
 */
public class PhpSourcePanelVisual extends javax.swing.JPanel {

    /** Creates new form PhpLanguagePanelVisual */
    PhpSourcePanelVisual(PhpSourcesConfigurePanel panel) {
        myPanel = panel;

        initComponents();

        init(panel);
    }

    private void init(PhpSourcesConfigurePanel panel) {
        configureExistingSourcesPanel(panel);
        // version panel is temporarily disabled. we now support only php v5
        //configureVersionPanel(panel);

        switch (panel.getWizardType()) {
            case EXISTING:
                setName(NbBundle.getBundle(NewPhpProjectWizardIterator.class).getString(NewPhpProjectWizardIterator.STEP_SOURCES));
                break;
            default:
                setName(NbBundle.getBundle(NewPhpProjectWizardIterator.class).getString(NewPhpProjectWizardIterator.STEP_PHP_LANGUAGE));
        }
    }

    boolean dataIsValid(WizardDescriptor wizardDescriptor) {
        boolean result = true;
        if (getSourcesPanel() != null) {
            result = result && getSourcesPanel().dataIsValid(wizardDescriptor);
        }
        if (getVersionPanel() != null) {
            result = result && getVersionPanel().dataIsValid(wizardDescriptor);
        }
        return result;
    }

    void read(WizardDescriptor descriptor) {
        if (getSourcesPanel() != null) {
            getSourcesPanel().read(descriptor);
        }
        if (getVersionPanel() != null) {
            getVersionPanel().read(descriptor);
        }
        validate();
    }

    void store(WizardDescriptor descriptor) {
        if (getSourcesPanel() != null) {
            getSourcesPanel().store(descriptor);
        }
        if (getVersionPanel() != null) {
            getVersionPanel().store(descriptor);
        }
    }


    private void configureExistingSourcesPanel(PhpSourcesConfigurePanel panel) {
        switch (panel.getWizardType()) {
            case EXISTING:
                if (mySourcesPanel == null) {
                    mySourcesPanel = new ExistingSourcesPanel(panel);
                    mySourcesContainer.add(BorderLayout.NORTH, mySourcesPanel);
                }
        }
    }

    private void configureVersionPanel(PhpSourcesConfigurePanel panel) {
        if (myVersionPanel == null) {
            myVersionPanel = new PhpVersionPanel(panel);
            myPhpVersionContainer.add(BorderLayout.NORTH, myVersionPanel);
        }
    }

    private PhpSourcesConfigurePanel getPanel() {
        return myPanel;
    }

    private PhpVersionPanel getVersionPanel() {
        return myVersionPanel;
    }

    private ExistingSourcesPanel getSourcesPanel() {
        return mySourcesPanel;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        myPhpVersionContainer = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        mySourcesContainer = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        myPhpVersionContainer.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(myPhpVersionContainer, gridBagConstraints);

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 343, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 227, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);

        mySourcesContainer.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(mySourcesContainer, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
            // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel myPhpVersionContainer;
    private javax.swing.JPanel mySourcesContainer;
    // End of variables declaration//GEN-END:variables
    private PhpVersionPanel myVersionPanel;
    private ExistingSourcesPanel mySourcesPanel;
    private PhpSourcesConfigurePanel myPanel;
}
