/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2007 Sun Microsystems, Inc.
 */
package org.netbeans.modules.php.rt.providers.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.modules.php.rt.spi.providers.ProjectCustomizerComponent;
import org.netbeans.modules.php.rt.spi.providers.ProjectCustomizerComponent.CustomizerChangeListener;

/**
 * Project customizer Component provided by Provider implementation.
 * Is used to view or set server-related options.<br/>
 * 
 * Each <code>ProjectCustomizerComponent</code> implementation can use 
 * <code>fireCustomizerErrorMessage(String msg)</code> and
 * <code>fireCustomizerPropertyChanged</code> to send notifications 
 * to listeners ( container Component).<br/>
 * 
 * <code>store(EditableProperties properties)</code> and 
 * <code>read(EditableProperties properties)</code> are invoked 
 * by listeners (container Component). Implement them to store or to load 
 * properties values.
 * 
 * @author avk
 */
public abstract class AbstractProjectCustomizerComponent extends ProjectCustomizerComponent{
    
    public void addCustomizerListener( CustomizerChangeListener listener ) {
        synchronized ( myListeners ) {
            myListeners.add(listener);
        }
    }

    public void removeCustomizerListener( CustomizerChangeListener listener ) {
        synchronized ( myListeners ) {
            myListeners.remove(listener);
        }
    }

    protected void fireCustomizerErrorMessage(String msg){
        CustomizerChangeListener[] listeners;
        synchronized ( myListeners) {
            listeners = myListeners.toArray( 
                    new CustomizerChangeListener[ myListeners.size() ] );
        }
        for (CustomizerChangeListener listener : listeners) {
            listener.errorAppeared(msg);
        }
    }
    
    /**
     * Notifies Listeners (e.g. container component), that one of important properties is modified.
     * 
     * Listeners will use <code>store(EditableProperties properties)</code> 
     * to get new values.
     */
    protected void fireCustomizerPropertyChanged() {
        CustomizerChangeListener[] listeners;
        synchronized ( myListeners) {
            listeners = myListeners.toArray( 
                    new CustomizerChangeListener[ myListeners.size() ] );
        }
        for (CustomizerChangeListener listener : listeners) {
            listener.propertyChanged(this);
        }
    }
    

    private final Collection<CustomizerChangeListener> myListeners = 
        new LinkedList<CustomizerChangeListener>();
    
    
}
