/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface;

/**
 *
 * @author marcow
 * The constants from dbg-cli/dbgbase/dbg_net.h
 */
public class DbgConstants {
    // version
    public static final int DBG_API_MAJOR_VESION        = 0x02;
    public static final int DBG_API_MINOR_VESION        = 0x15;
    public static final int DBG_API_RELEASE_STAGE       = 0x03;   // 0-dev, 1-beta, 2-prerelease, 3-release
    public static final int DBG_API_MINOR_SUB_VESION    = 0x01;

    public static final String DBG_PROD_NAME    = "DBG php debugger"; // NOI18N
    public static final String DBG_PROD_COPYR   = "Copyright 2001, 2006, Dmitri Dmitrienko, www.nusphere.com"; // NOI18N
    public static final String DBG_API_DESCRIPTION = DBG_PROD_NAME + ", version " + // NOI18N
            DBG_API_MAJOR_VESION + "." + DBG_API_MINOR_VESION + "." + // NOI18N
            DBG_API_MINOR_SUB_VESION + " " + DBG_PROD_COPYR; // NOI18N
    public static final int DBG_DEFAULT_PORT    = 7869;
    public static final String DBG_SESSION_VAR  = "DBGSESSID";
    public static final int DBG_SYNC            = 0x00005953;

    // session type
    public static final int DBG_SESSION_COMPAT  = 0x0001;
    public static final int DBG_SESSION_JIT     = 0x0002;
    public static final int DBG_SESSION_REQ     = 0x0003;
    public static final int DBG_SESSION_EMB     = 0x0004;

    // C O M M A N D   I N T E R F A C E
    // debugger_flags
    // state:
    public static final int DBGF_STARTED        = 0x0001;       // debugger has been started
    public static final int DBGF_FINISHED       = 0x0002;       // DBGC_END notification has been sent
    public static final int DBGF_WAITACK        = 0x0004;       // awaiting replay|request
    public static final int DBGF_UNSYNC         = 0x0008;       // protocol has been unsynchronized
    public static final int DBGF_REQUESTPENDING = 0x0010;       // Debug session request pending
    public static final int DBGF_REQUESTFOUND   = 0x0020;       // Debug session request found
    public static final int DBGF_REJECTIONFOUND = 0x0040;       // DBGSESSID=-1 found - session rejection
            
    // execution:
    public static final int DBGF_STEPINTO       = 0x0100;       // break on next script instruction
    public static final int DBGF_STEPOVER       = 0x0200;       // break on next script instruction on the same context
    public static final int DBGF_STEPOUT        = 0x0400;       // break on next script instruction on the outer context
    public static final int DBGF_ABORT          = 0x0800;       // stop instruction passed

    // PHP ENGINE to DEBUGGER CLIENT WAY:
    // php-engine commands/events
    public static final int DBGC_REPLY          = 0x0000;       // reply to previous DBGA_REQUEST request
    public static final int DBGC_STARTUP        = 0x0001;       // script startup
    public static final int DBGC_END            = 0x0002;       // script done
    public static final int DBGC_BREAKPOINT     = 0x0003;       // user definded breakpoint occured
    public static final int DBGC_STEPINTO_DONE  = 0x0004;       // step to the next statement is completed
    public static final int DBGC_STEPOVER_DONE  = 0x0005;       // step to the next statement is completed
    public static final int DBGC_STEPOUT_DONE   = 0x0006;       // step to the next statement is completed
    public static final int DBGC_EMBEDDED_BREAK = 0x0007;       // breakpoint caused by DebugBreak() function
    public static final int DBGC_ERROR          = 0x0010;       // error occured
    public static final int DBGC_LOG            = 0x0011;       // logging support
    public static final int DBGC_SID            = 0x0012;       // send SID
    public static final int DBGC_PAUSE          = 0x0013;       // pause current session as soon as possible

    public static final int FRAME_STACK         = 100000;       // "call:stack" - e.g. backtrace
    public static final int FRAME_SOURCE        = 100100;       // source text
    public static final int FRAME_SRC_TREE      = 100200;       // tree of source files
    public static final int FRAME_RAWDATA       = 100300;       // raw data or string
    public static final int FRAME_ERROR         = 100400;       // error notification
    public static final int FRAME_EVAL          = 100500;       // evaluating/watching
    public static final int FRAME_BPS           = 100600;       // set/remove breakpoint
    public static final int FRAME_BPL           = 100700;       // breakpoint(s) request = get the list
    public static final int FRAME_VER           = 100800;       // version request
    public static final int FRAME_SID           = 100900;       // session id info
    public static final int FRAME_SRCLINESINFO  = 101000;       // source lines info
    public static final int FRAME_SRCCTXINFO    = 101100;       // source contexts info
    public static final int FRAME_LOG           = 101200;       // logging
    public static final int FRAME_PROF          = 101300;       // profiler
    public static final int FRAME_PROF_C        = 101400;       // profiler counter/accuracy
    public static final int FRAME_SET_OPT       = 101500;       // set/update options

    // DEBUGGER CLIENT to DBG SERVER WAY:
    // debugger client makes acknowledgement
    public static final int DBGA_CONTINUE       = 0x8001;       // php should continue run
    public static final int DBGA_STOP           = 0x8002;
    public static final int DBGA_STEPINTO       = 0x8003;
    public static final int DBGA_STEPOVER       = 0x8004;
    public static final int DBGA_STEPOUT        = 0x8005;
    public static final int DBGA_IGNORE         = 0x8006;
    public static final int DBGA_REQUEST        = 0x8010;       // debugger client requests some information from PHP engine

    public static final int BPS_DELETED         = 0;
    public static final int BPS_DISABLED        = 1;
    public static final int BPS_ENABLED         = 2;
    public static final int BPS_UNRESOLVED      = 0x0100;
    
    // FRAME_ERROR types
    public static final int ERR_ERROR           = 0x01;
    public static final int ERR_WARNING         = 0x02;
    public static final int ERR_PARSE           = 0x04;
    public static final int ERR_NOTICE          = 0x08;
    public static final int ERR_CORE_ERROR      = 0x10;
    public static final int ERR_CORE_WARNING    = 0x20;
}
