<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@ page import="org.netbeans.server.uihandler.statistics.Help" %>
<%@ page import="org.netbeans.server.uihandler.statistics.Help.Invocations" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.Set" %>
<%@ taglib uri="/WEB-INF/chart-tag.tld" prefix="chart"%>
<%@ taglib uri="/WEB-INF/statistics.tld" prefix="ui"%>

<head>
<jsp:include page="../template/header.jsp"/>
<ui:useStatistic name="Help"/>

<a href="http://www.netbeans.org/index.html">HOME</a> 
/ 
<a href="http://www.netbeans.org/community/index.html">Community</a>
/
<a href="index.jsp">Analytics</a>
/
Graph
/
JavaHelp

</div><td class="valign-top b-right full-width">

    <div class="f-page-cell bg-sky" >
        <h2>Do people use context help?</h2>
        
        <p>
            Sometimes our users need a little bit of help. Do they search
            for it on google or do they invoke our integrated help documentation?
            This project of course cannot answer the first question (yet),
            but it can create a hitparade of the most used topics people
            invoke help on.
        </p>
    </div>

    <% 
        Invocations invLast = (Invocations)pageContext.getAttribute("lastHelp");
        Set<Invocations.One> last = invLast == null ? null : invLast.getTopTen();
        Invocations invUser = (Invocations)pageContext.getAttribute("userHelp");
        Set<Invocations.One> user = invUser == null ? null : invUser.getTopTen();
        Invocations invAll = (Invocations)pageContext.getAttribute("globalHelp");
        Set<Invocations.One> all = invAll == null ? null : invAll.getTopTen();
    %>

    <p class="b-bottom-dashed b-top f-page-cell">
    <% if (last == null || last.isEmpty()) { %>
        You do not seem to use the help since your last submission at all
        (or your are using NetBeans 6.0 Milestone 8 or older build)! 
        If you want to access the integrated
        help press <code>F1</code> in any dialog or window and a context
        sensitive help window shows up with content related to the place
        and task you are just performing.
    <% } else { %>
        Here is the list of the most popular contexts you have invoked help
        in the last session.
        <table width="100%" class="full-width-collapse" >
            <thead><th align="left">Help Topic</th><th align="left">Invocations</th></thead>
            
            <% for (Invocations.One inv : last) { %>
            <tr class="full-width-collapse">
                <td class="floating-wrap-table"><% out.println(inv.getId()); %></td>
                <td class="floating-wrap-table"><% out.println(inv.getCnt()); %></td>
            </tr>
            <% } %>
        </table>
    <% } %>
    </p>

    <p class="b-bottom-dashed b-top f-page-cell">
    <% if (user == null || user.isEmpty()) { %>
        You do not seem to use the help at all
        (or your are using NetBeans 6.0 Milestone 8 or older build)! 
        If you want to access the integrated
        help press <code>F1</code> in any dialog or window and a context
        sensitive help window shows up with content related to the place
        and task you are just performing.
    <% } else { %>
        Here is cumulative list of your most often help invocations including
        their repetitiveness:
        <table width="100%" class="full-width-collapse" >
            <thead><th align="left">Help Topic</th><th align="left">Invocations</th></thead>
            
            <% for (Invocations.One inv : user) { %>
            <tr class="full-width-collapse">
                <td class="floating-wrap-table"><% out.println(inv.getId()); %></td>
                <td class="floating-wrap-table"><% out.println(inv.getCnt()); %></td>
            </tr>
            <% } %>
        </table>
    <% } %>
    </p>
    
    <p class="b-bottom-dashed b-top f-page-cell">
    <% if (all == null || all.isEmpty()) { %>
        No data about help usage yet, sorry.
    <% } else { %>
        Here is a table showing top ten of most <q>confusing</q> places the application
        you have just used. These are the places where most people invoke help on.
        
        <table width="100%" class="full-width-collapse" >
            <thead><th align="left">Help Topic</th><th align="left">Invocations</th></thead>
            
            <% for (Invocations.One inv : all) { %>
            <tr class="full-width-collapse">
                <td class="floating-wrap-table"><% out.println(inv.getId()); %></td>
                <td class="floating-wrap-table"><% out.println(inv.getCnt()); %></td>
            </tr>
            <% } %>
        </table>
    <% } %>
    </p>
    
    <p class="b-bottom-dashed b-top f-page-cell">
        Another interesting way to look at our data is how many times people
        really do need help. Here is a table showing the number of sessions 
        (e.g. uploaded logs) that contain the log data vs. those that do not:
        
        <chart:pie collection="globalHelpRatio" category="key" value="value"/>
    </p>
<jsp:include page="../template/footer.jsp"/>
