/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * Copyright 2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.netbeans.server.uihandler;

import java.util.prefs.Preferences;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/**LogRecord number 0 contains userData(operating system, virtual machine,
 * NetBeans product version,  user name, summary and comment
 * LogRecord number 1 contains lastly thrown exception
 * LogRecord number 2 contains issueId if duplicate
 *
 * @author Jindrich Sedek
 */
public class Exceptions extends Statistics<Map<Integer,LogRecord>> {
    private static final Logger LOG = Logger.getLogger(Exceptions.class.getName());
    public static final String USER_CONFIGURATION = "UI_USER_CONFIGURATION";   // NOI18N
    
    /** Creates a new instance of Exceptions */
    
    public Exceptions() {
        super("Exceptions");
    }
    
    protected Map<Integer, LogRecord> newData() {
        return Collections.emptyMap();
    }
    
    protected Map<Integer, LogRecord> process(LogRecord rec) {
        Map<Integer, LogRecord> coll = new HashMap<Integer, LogRecord>();
        if (USER_CONFIGURATION.equals(rec.getMessage())){
            coll.put(0, rec);
        }
        if ((rec.getThrown()!= null)&&(rec.getLevel().intValue() >= Level.WARNING.intValue())){
            coll.put(1, rec);
            
        }
        return coll;
    }
    
    protected Map<Integer, LogRecord> join(Map<Integer, LogRecord> one,
            Map<Integer, LogRecord> two) {
        Map<Integer, LogRecord> result = new HashMap<Integer, LogRecord>();
        // there is only one user data in one report
        if (one.get(0) != null) result.put(0, one.get(0));
        else if (two.get(0) != null) result.put(0, two.get(0));
        //user last exception you get
        if (two.get(1)!=null) result.put(1, two.get(1));
        else if (one.get(1) != null) result.put(1, one.get(1));
        return result;
    }
    
    /*
     * @return CheckIssue value in LogRecord 2
     */
    protected Map<Integer, LogRecord> finishSessionUpload(String userId,
            int sessionNumber,
            boolean initialParse,
            Map<Integer, LogRecord> data) {
        Object[] dbInsertionresult = null;
        if (initialParse){
            LogRecord metaData = data.get(0);
            if (metaData==null) LOG.info("METADATA = NULL");    // NOI18N
            else if (metaData.getParameters()==null) LOG.info("PARAMETERS = NULL"); // NOI18N
            else{
                int length = metaData.getParameters().length;
                Throwable thrown = null;
                if ((data.get(1) != null)&&(length>=6)){// summary and comment are send => report
                    thrown = data.get(1).getThrown();
                }
                DbInsertion insertion;
                insertion = new DbInsertion(metaData, thrown, userId, sessionNumber); // NOI18N
                dbInsertionresult = insertion.start();
            }
        }
        LogRecord log = new LogRecord(Level.CONFIG, "RESULT");
        if (dbInsertionresult != null) log.setParameters(dbInsertionresult);
        Map<Integer, LogRecord> d = new HashMap<Integer, LogRecord>();
        d.put(2, log);
        LOG.finest("EXCEPTIONS UPLOAD FINISHED"); // NOI18N
        return d;
    }

    protected void write(Preferences pref, Map<Integer, LogRecord> d) {
        assert d.get(0) == null;
        assert d.get(1) == null;
        LogRecord rec = d.get(2);
        if (rec == null || rec.getParameters() == null || rec.getParameters().length != 3) {
            return;
        }
        // int, boolean, int
        pref.putInt("0", (Integer)rec.getParameters()[0]);
        pref.putBoolean("1", (Boolean)rec.getParameters()[1]);
        pref.putInt("2", (Integer)rec.getParameters()[2]);
    }

    protected Map<Integer, LogRecord> read(Preferences pref) {
        int i0 = pref.getInt("0", -1);
        boolean b1 = pref.getBoolean("1", false);
        int i2 = pref.getInt("2", -1);
        
        if (i0 == -1 && i2 == -1) {
            LogRecord log = new LogRecord(Level.CONFIG, "RESULT");
            return Collections.singletonMap(2, log);
        }

        LogRecord log = new LogRecord(Level.CONFIG, "RESULT");
        log.setParameters( new Object[] { i0, b1, i2 });
        Map<Integer, LogRecord> d = new HashMap<Integer, LogRecord>();
        d.put(2, log);
        return d;
    }
    
}
