/*
 * LoggerAsXML.java
 *
 * Created on 12 April 2007, 11:10
 */

package org.netbeans.modules.exceptions.web;

import java.io.*;
import java.net.*;
import java.util.logging.LogRecord;
import javax.servlet.*;
import javax.servlet.http.*;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.utils.LoggerUtils;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
import java.io.BufferedInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.netbeans.lib.uihandler.LogRecords;

/**
 *
 * @author honza
 * @version
 */
public class LoggerAsXML extends HttpServlet {

    /**
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer id = null;
        try {
            id = new Integer(request.getParameter("id"));
        } catch (NumberFormatException e) {
        }
        if (id != null) {
            Exceptions exceptions = (Exceptions) PersistenceUtils.getInstance().getEntity(Exceptions.class, id);

            response.setContentType("text/xml;charset=UTF-8");
            OutputStream out = response.getOutputStream();
            PrintWriter output = new PrintWriter(out);
            output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            output.println("<uigestures>");
            output.flush();
            InputStream is = LoggerUtils.getLoggerAsInputStream(exceptions.getLoggername());
            InputStream buffGunzipped = new BufferedInputStream(new GZIPInputStream(is));
            LogRecords.scan(buffGunzipped, new MyHandler(out));
            output.println("</uigestures>");
            output.flush();
            output.close();
            out.close();
        }
    }

    private class MyHandler extends Handler {

        static final String USER_CONFIGURATION = "UI_USER_CONFIGURATION"; // NOI18N
        OutputStream output;
        Logger logger = Logger.getLogger(LoggerAsXML.class.getName());

        public MyHandler(OutputStream oStream) {
            output = oStream;
        }

        public void publish(LogRecord record) {
            if (USER_CONFIGURATION.equals(record.getMessage())) {
                Object[] params = record.getParameters();
                if (params != null && params.length >= 7) {
                    ArrayList<Object> list = new ArrayList( Arrays.asList(params));
                    list.remove(6);
                    record.setParameters(list.toArray());
                }
            }
            try {
                LogRecords.write(output, record);
            } catch (IOException ex) {
                logger.log(Level.SEVERE, "PUBLISHING LOG RECORD", ex);
            }
        }

        public void flush() {
            try {
                output.flush();
            } catch (IOException exception) {
                logger.log(Level.SEVERE, "FLUSHING SERVLET OUTPUT", exception);
            }
        }

        public void close() throws SecurityException {
            try {
                output.close();
            } catch (IOException exception) {
                logger.log(Level.SEVERE, "CLOSING SERVLET OUTPUT", exception);
            }
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
