/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.jaxwssupport;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

/**
 * Base class for sun jax ws refactoring elements.
 *
 * @author Erno Mononen
 */
public abstract class SunJaxWsXmlElementSupport extends AbstractRenameRefactoringElement implements ExternalChange {
    
    private Endpoint endpoint;
    private Endpoints model;
    
    /**
     * Creates a new instance of JaxWsXmlRefactoringElementSupport
     * @param oldName the fully qualified old name of the implementation class.
     * @param newName the fully qualified new name of the implementation class.
     * @model the model representing <code>sun-jaxws.xml</code>.
     * @endpoint the endpoint whose implementation class is to be renamed.
     * @parentFile the file object representing jax-ws.xml.
     */
    public SunJaxWsXmlElementSupport(String oldName,  String newName,
            Endpoints model, Endpoint endpoint,  FileObject parentFile) {
        
        this.oldName = oldName;
        this.newName = newName;
        this.endpoint = endpoint;
        this.model = model;
        this.parentFile = parentFile;
    }
    
    public void undoExternalChange() {
        model.findEndpointByName(endpoint.getEndpointName()).setImplementation(oldName);
        writeModel();
    }
    
    public void performExternalChange() {
        model.findEndpointByName(endpoint.getEndpointName()).setImplementation(newName);
        writeModel();
    }
    
    /**
     * Writes the model.
     */
    protected void writeModel(){
        FileLock lock = null;
        try {
            lock = parentFile.lock();
            OutputStream os = parentFile.getOutputStream(lock);
            try{
                model.write(os);
            } finally {
                os.close();
            }
        } catch (IOException ex) {
            ErrorManager.getDefault().notify(ex);
        } finally {
            lock.releaseLock();
        }
    }
    public void performChange() {
        JavaMetamodel.getManager().registerExtChange(this);
    }
    
    
}
