/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.form.layoutsupport;

import org.openide.nodes.Node;

/**
 * This interface represents one layout constraints object describing position
 * of a component in visual container layout. This interface is the second part
 * of the layout support extensions - alongside LayoutSupportDelegate, which
 * takes care about container layout as a whole.
 *
 * @see LayoutSupportDelegate
 *
 * @author Tomas Pavek
 */

public interface LayoutConstraints {

    /** Gets the properties of these component layout constraints to be
     * presented in Component Inspector for the component.
     * @return properties of these constraints
     */
    Node.Property[] getProperties();

    /** Gets the real (reference) constraints object behind this metaobject.
     * This object is used as the constraints parameter when adding a component
     * to container.
     * @return the real constraints object
     */
    Object getConstraintsObject();

    /** Cloning method - creates a copy of the constraints. It should clone
     * the reference object inside.
     * @return cloned LayoutConstraints
     */
    LayoutConstraints cloneConstraints();
}
