import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.junit.MockServices;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
public class Relative2Position {
    public static void main(String[] args) throws Exception {
        MockServices.setServices(DummyCatalog.class);
        File nball = FileUtil.normalizeFile(new File("../.."));
        System.out.println("nball=" + nball);
        PropertyEvaluator clusterProperties = PropertyUtils.sequentialPropertyEvaluator(null,
                PropertyUtils.propertiesFilePropertyProvider(new File(nball, "nbbuild/cluster.properties")));
        String clusters = clusterProperties.getProperty("clusters.config." + clusterProperties.getProperty("cluster.config") + ".list") + ",nb.cluster.cnd";
        Collection<LayerUtils.LayerHandle> handles = new LinkedList<LayerUtils.LayerHandle>();
        List<FileSystem> layers = new ArrayList<FileSystem>();
        Map<String,Integer> folderDefinerChildCounts = new HashMap<String,Integer>();
        Map<String,LayerUtils.LayerHandle> folderDefiners = new HashMap<String,LayerUtils.LayerHandle>();
        for (String cluster : clusters.split("[, ]+")) {
            for (String module : Arrays.asList(clusterProperties.getProperty(cluster).split("[, ]+"))) {
                if (module.equals("core/applemenu")) {
                    // Just hides some things and screws up the order, e.g. of File > Exit.
                    continue;
                }
                File prjdir = new File(nball, module);
                assert prjdir.isDirectory() : prjdir;
                Project p = ProjectManager.getDefault().findProject(FileUtil.toFileObject(prjdir));
                LayerUtils.LayerHandle handle = LayerUtils.layerForProject(p);
                FileSystem layer = handle.layer(false);
                if (layer != null) {
                    handles.add(handle);
                    layers.add(layer);
                    // Try to guess which layer "defines" a given folder.
                    // Simple heuristic: whoever defines the most children defines the folder.
                    // Also give preference to layers in more basic clusters (currently hardcoded).
                    for (FileObject d : NbCollections.iterable(handle.layer(false).getRoot().getChildren(true))) {
                        if (!d.isFolder()) {
                            continue;
                        }
                        int count = d.getChildren().length;
                        if (cluster.contains("platform")) {
                            count += 400;
                        } else if (cluster.contains("ide")) {
                            count += 300;
                        } else if (cluster.contains("java")) {
                            count += 200;
                        } else if (cluster.contains("j2ee")) {
                            count += 100;
                        }
                        String path = d.getPath();
                        if (!folderDefinerChildCounts.containsKey(path) || count > folderDefinerChildCounts.get(path)) {
                            folderDefinerChildCounts.put(path, count);
                            /*LayerUtils.LayerHandle previous = */folderDefiners.put(path, handle);
                            /*
                            if (previous != null) {
                                System.out.println("overriding owner for " + path + " with " + handle + " over " + previous);
                            } else {
                                System.out.println("owning " + path + " with " + handle);
                            }
                             */
                        }
                    }
                }
            }
        }
        FileSystem merged = new MultiFileSystem(layers.toArray(new FileSystem[layers.size()]));
        Map<String,Map<String,Integer>> orders = new TreeMap<String,Map<String,Integer>>();
        for (FileObject d : NbCollections.iterable(merged.getRoot().getChildren(true))) {
            if (!d.isFolder()) {
                continue;
            }
            String path = d.getPath();
            LayerUtils.LayerHandle handle = folderDefiners.get(path);
            assert handle != null : path;
            Matcher m = Pattern.compile("Editors/((text|application)/([^/]+))/(.+)").matcher(path);
            if (m.matches()) {
                String basePath = "Editors/" + m.group(4);
                // XXX this is not sufficient for text/*+xml MIME types, which merge against both "" and text/xml...
                final Map<String,Integer> baseOrder = orders.get(basePath);
                if (baseOrder != null) {
                    assert !baseOrder.isEmpty();
                    System.out.println("(merging " + path + " against " + basePath + ")");
                    // Expand the base orders so we have more room (if no one has done so already).
                    if (baseOrder.values().contains(100)) {
                        for (Map.Entry<String,Integer> entry : baseOrder.entrySet()) {
                            entry.setValue(entry.getValue() * 10);
                        }
                    }
                    // Do topo sort manually; probably simpler than faking out FileUtil.getOrder.
                    Map<String,Set<String>> edges = new HashMap<String,Set<String>>();
                    // Base order is fixed.
                    String preceding = null;
                    for (String s : baseOrder.keySet()) {
                        if (preceding != null) {
                            edges.put(preceding, new HashSet<String>(Collections.singleton(s)));
                        }
                        preceding = s;
                    }
                    // Add in rel attrs from the derivative folder.
                    for (String attr : NbCollections.iterable(d.getAttributes())) {
                        int slash = attr.indexOf('/');
                        if (slash != -1) {
                            String before = attr.substring(0, slash);
                            String after = attr.substring(slash + 1);
                            Set<String> ends = edges.get(before);
                            if (ends == null) {
                                edges.put(before, ends = new HashSet<String>());
                            }
                            ends.add(after);
                        }
                    }
                    Set<String> sortables = new HashSet<String>();
                    for (FileObject f : d.getChildren()) {
                        sortables.add(f.getNameExt());
                    }
                    // Verify that all files are distinct.
                    for (String s : baseOrder.keySet()) {
                        if (!sortables.add(s)) {
                            throw new Exception("Found " + s + " in both folders!");
                        }
                    }
                    // Go through the merged order and assign positions to derived files.
                    List<String> mergedOrder = Utilities.topologicalSort(sortables, edges);
                    System.out.println("(merged order: " + mergedOrder + ")");
                    Map<String,Integer> files = new LinkedHashMap<String,Integer>();
                    // Find files preceding first base file.
                    int pos = 0;
                    int precedingCount = 0;
                    for (String s : mergedOrder) {
                        if (baseOrder.containsKey(s)) {
                            pos = baseOrder.get(s);
                            break;
                        } else {
                            precedingCount++;
                        }
                    }
                    // Magic loop which assigns positions to derived files before or between base files.
                    List<String> intermediate = new ArrayList<String>();
                    for (String s : mergedOrder) {
                        if (precedingCount > 0) {
                            files.put(s, pos - 100 * precedingCount--);
                        } else if (baseOrder.containsKey(s)) {
                            int end = baseOrder.get(s);
                            int incr = (end - pos) / (intermediate.size() + 1);
                            for (String s2 : intermediate) {
                                files.put(s2, pos += incr);
                            }
                            pos = end;
                            intermediate.clear();
                        } else {
                            intermediate.add(s);
                        }
                    }
                    // Assign positions to derived files after any base files.
                    for (String s : intermediate) {
                        files.put(s, pos += 100);
                    }
                    assert files.size() == d.getChildren().length : "Wrong count in " + files + " vs. " + Arrays.asList(d.getChildren());
                    orders.put(path, files);
                    System.out.println(path + ": " + files);
                    continue;
                } else {
                    System.out.println("(no base order in " + basePath + " to merge " + path + " against)");
                }
            }
            Set<FileObject> orderedKids = new HashSet<FileObject>();
            for (String attr : NbCollections.iterable(d.getAttributes())) {
                int slash = attr.indexOf('/');
                if (slash != -1) {
                    for (String name : new String[] {attr.substring(0, slash), attr.substring(slash + 1)}) {
                        FileObject f = d.getFileObject(name);
                        if (f != null && f.getParent() == d) {
                            orderedKids.add(f);
                        }
                    }
                }
            }
            if (orderedKids.isEmpty()) {
                System.out.println("(no orders in " + path + ")");
                continue;
            }
            Map<String,Integer> files = new LinkedHashMap<String,Integer>();
            int pos = 0;
            for (FileObject f : FileUtil.getOrder(orderedKids, false)) {
                files.put(f.getNameExt(), pos += 100);
            }
            orders.put(path, files);
            System.out.println(path + ": " + files);
            Set<FileObject> others = new HashSet<FileObject>(Arrays.asList(d.getChildren()));
            others.removeAll(orderedKids);
            if (!others.isEmpty()) {
                System.out.print("(skipping:");
                for (FileObject f : others) {
                    System.out.print(" " + f.getNameExt());
                }
                System.out.println(")");
            }
        }
        StringBuffer wrote = new StringBuffer("Wrote in " + nball + ":");
        for (LayerUtils.LayerHandle handle : handles) {
            for (FileObject d : NbCollections.iterable(handle.layer(false).getRoot().getChildren(true))) {
                if (!d.isFolder()) {
                    continue;
                }
                for (String attr : NbCollections.iterable(d.getAttributes())) {
                    if (attr.indexOf('/') != -1 && d.getAttribute(attr) instanceof Boolean) {
                        d.setAttribute(attr, null);
                    }
                }
                String path = d.getPath();
                Map<String,Integer> order = orders.get(path);
                if (order == null) {
                    continue;
                }
                for (Map.Entry<String,Integer> entry : order.entrySet()) {
                    FileObject f = d.getFileObject(entry.getKey());
                    if (f != null && (f.isData() || folderDefiners.get(f.getPath()) == handle)) {
                        if (f.isFolder()) {
                            System.out.println("Owner of " + f.getPath() + ": " + handle +
                                    " (with adjusted count: " + folderDefinerChildCounts.get(f.getPath()) + ")");
                        }
                        if (f.getAttribute("position") != null) {
                            throw new Exception("Will not clobber 'position' attr on " + f.getPath());
                        }
                        f.setAttribute("position", entry.getValue());
                    /*
                    } else if (f != null && f.isFolder()) {
                        System.out.println("Not writing " + f.getPath() + " from " + handle +
                                " because owner is " + folderDefiners.get(f.getPath()));
                     */
                    }
                }
            }
            System.out.println("Saving: " + handle);
            File layerFile = FileUtil.toFile(handle.getLayerFile());
            layerFile.setWritable(true);
            handle.save();
            wrote.append(' ').append(PropertyUtils.relativizeFile(nball, layerFile));
        }
        System.out.println(wrote);
    }
    public static class DummyCatalog extends UserCatalog implements EntityResolver {
        public EntityResolver getEntityResolver() {
            return this;
        }
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if ("-//NetBeans//DTD Filesystem 1.1//EN".equals(publicId)) {
                return new InputSource(DummyCatalog.class.getClassLoader().getResource("org/openide/filesystems/filesystem1_1.dtd").toExternalForm());
            } else if ("-//NetBeans//DTD Filesystem 1.0//EN".equals(publicId)) {
                return new InputSource(DummyCatalog.class.getClassLoader().getResource("org/openide/filesystems/filesystem.dtd").toExternalForm());
            } else {
                return null;
            }
        }
    }
}
