/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: connections.c,v 1.58 2009-07-21 14:08:59 jura Exp $ */

#include "netams.h"

//////////////////////////////////////////////////////////////////////////////////////////
ConnectionsList *Connections=NULL;
//////////////////////////////////////////////////////////////////////////////////////////
Connection::Connection():Object(){
	t_id=0;

	user=NULL;
	socket = 0;
	cli=NULL;
	addr=(struct sockaddr_in*)aMalloc(sizeof(struct sockaddr_in));

	permissions=UPERM_ALL;

	t_connected=t_lastcmd=0;
}

Connection::~Connection(){
	aFree(addr);
}

void Connection::setConnection(int fd, struct sockaddr_in *sock_addr) {
	aDebugAdd(&debug, "none");
	socket = fd;
	bcopy(sock_addr, addr, sizeof(struct sockaddr_in));

	//init cli
	cli = cli_init();
	cli->conn = (void*)this;
	cli_unregister_all(cli, NULL);
	cli->commands = CLI->commands;
	cli_set_auth_callback(cli, aAuth);
	if(enable_password) cli_set_enable_callback(cli, aEnable);

	t_connected=t_lastcmd=time(NULL);
	permissions=UPERM_ALL;
}

void Connection::clearConnection() {
	if (socket>0) {
		shutdown(socket, SHUT_RDWR);
		close(socket);
	}
	cli->commands=NULL; //because we borow commands from CLI
	cli_done(cli);
}
//////////////////////////////////////////////////////////////////////////////////////////
// Connections management
ConnectionsList::ConnectionsList():List(){
	last_conn_id=0;
}

Connection *ConnectionsList::getConnectionByThr(pthread_t t){
	Connection *d=NULL;

	pthread_rwlock_rdlock(&rwlock);
	for(d=(Connection*)root; d!=NULL; d=(Connection*)d->next)
		if (pthread_equal(t, d->t_id))
			break;
	pthread_rwlock_unlock(&rwlock);
	return d;
}

void ConnectionsList::listConnections(struct cli_def *cli){
	Connection *t;
	time_t idle;
	unsigned long days, hours, mins, secs;
	char buf[32];
	char start[32];
	char stop[32];

	netams_rwlock_rdlock(&rwlock);
	cli_print(cli, "%6s | %8s | %10s | %18s | %10s", "ID", "IDLE", "CONNECTED", "ADDR", "PERMIT");
	for(t=(Connection*)root; t!=NULL; t=(Connection*)t->next){

		idle = time(NULL) - t->t_lastcmd;
		days=idle/(60*60*24);
		hours=(idle-days*60*60*24)/(60*60);
		mins=(idle-(days*60*60*24)-(hours*60*60))/60;
		secs=idle-(days*60*60*24)-(hours*60*60)-mins*60;

		if (days>0) sprintf(start, "%4ldd%2ldh", days, hours);
		else if (hours>0) sprintf(start, "%4ldh%2ldm", hours, mins);
		else if (mins>0) sprintf(start, "%4ldm%2lds", mins, secs);
	  	else sprintf(start, "%7lds", secs);

		idle = time(NULL) - t->t_connected;
		days=idle/(60*60*24);
		hours=(idle-days*60*60*24)/(60*60);
		mins=(idle-(days*60*60*24)-(hours*60*60))/60;
		secs=idle-(days*60*60*24)-(hours*60*60)-mins*60;

		if (days>0) sprintf(stop, "  %4ldd%2ldh", days, hours);
		else if (hours>0) sprintf(stop, "  %4ldh%2ldm", hours, mins);
		else if (mins>0) sprintf(stop, "  %4ldm%2lds", mins, secs);
	  	else sprintf(stop, "  %7lds", secs);

		if (t->addr) inet_ntop(AF_INET, &(t->addr->sin_addr), buf, 32); else buf[0]='\0';
		cli_print(cli, "%06u | %s | %s | %18s | %10s",
			t->id, start, stop,
			buf, permissions_list[t->permissions]);
	}
	netams_rwlock_unlock(&rwlock);
}

void ConnectionsList::CancellAll(){
//    netams_rwlock_rdlock(&rwlock);
	for(Connection *next,*c=(Connection*)root; c!=NULL; c=next) {
		next=(Connection*)c->next;
		pthread_cancel(c->t_id);
        pthread_join(c->t_id, NULL);
	}
//    netams_rwlock_unlock(&rwlock);
}
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
