// Copyright (c) 2003-2005 The University of Wroclaw.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//    1. Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//    2. Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//    3. The name of the University may not be used to endorse or promote
//       products derived from this software without specific prior
//       written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

using Nemerle.Utility;

namespace Nemerle.CSharp
{
    public module Options
    {
	public mutable OutputFileName : option [string] = None ();
	public mutable NemerlishFunctionParameters : bool = false;
	public mutable NemerlishDefaultValue : bool = false;
	public mutable NemerlishForeach : bool = false;
	public mutable ColorMessages : bool = true;
	
	public GetCommonOptions () : list [Getopt.CliOption]
	{
	    def nemerlish_function_parameters () { NemerlishFunctionParameters = true; }
	    
	    def nemerlish_default_value () { NemerlishDefaultValue = true;}
	    
	    def nemerlish_foreach () { NemerlishForeach = true;}
	    	    
	    def nemerlish_all ()
	    {
		nemerlish_default_value ();
		nemerlish_function_parameters ();
		nemerlish_foreach ();
	    }
	    
	    [Getopt.CliOption.String (name = "-out",
                       aliases = ["-o"],
                       help = "Output file name",
                       handler = fun (s) { Options.OutputFileName = Some (s) }),

	    Getopt.CliOption.Flag (name = "-nemerlish-function-parameters", 
                     aliases = ["-nfp"],
                     help = "Turn on nemerlish function parameter flag",
                     handler = nemerlish_function_parameters),

	    Getopt.CliOption.Flag (name = "-nemerlish-default-value", 
                     aliases = ["-ndv"],
                     help = "Turn on nemerlish default value flag",
                     handler = nemerlish_default_value),

	    Getopt.CliOption.Flag (name = "-nemerlish-foreach", 
                     aliases = ["-nf"],
                     help = "Turn on nemerlish foreach flag",
                     handler = nemerlish_foreach),

	    Getopt.CliOption.Flag (name = "-nemerlish", 
                     aliases = ["-n"],
                     help = "Turn on all nemerlish flags",
                     handler = nemerlish_all),

	    Getopt.CliOption.Flag (name = "-no-color", 
                     aliases = [],
                     help = "Disable coloring of error/warning messages",
                     handler = fun () { Options.ColorMessages = false; }),
	    ]
	}
    }
}
