using System;
using Gtk;

class NMenuItem : MenuItem
{
	public name : string;
	
	public this(l : string) 
	{
		base(l);
		name = l;		
	}

	public this(l : string, e : object * EventArgs -> void) 
	{
		base(l);
		name = l;		
		this.Activated += e;
	}


        // this property allows us to set submenus of this menu item
	public SubmenuList : list [NMenuItem]
	{ 
		set
		{ 
			def sub = Menu();
                        foreach (submenu in value) sub.Append (submenu);
			this.Submenu = sub;
		}
	}
}


class MainWindow : Window
{
        /// text input area of our window
	input : TextView;

	public this()
	{
                // set caption of window
		base ("Very Simple Editor");
                // resize windows to some reasonable shape
		SetSizeRequest (300,200);

		def scroll = ScrolledWindow ();		
		input = TextView ();
		scroll.Add (input);

		def menu = MenuBar ();
		def mi = NMenuItem ("File");
		mi.SubmenuList = 
		[
			NMenuItem ("Open", OnMenuFile),
			NMenuItem ("Save as...", OnMenuFile)
		];
		menu.Append(mi);		
		
		def vbox = VBox ();
		vbox.PackStart (menu, false, false, 0u);
	        vbox.PackStart (scroll, true, true, 0u);

		// place vertical box inside our main window
		Add (vbox);
	}

        // handler of opening and saving files
	OnMenuFile (i : object, _ : EventArgs) : void
	{
		def mi = i :> NMenuItem;
		def fs = FileSelection (mi.name);
		
		when (fs.Run () == ResponseType.Ok :> int) match (mi.name)
		{
			| "Open" =>
                                def stream = IO.StreamReader (fs.Filename);
				input.Buffer.Text = stream.ReadToEnd();

			| "Save as..." =>
				def s = IO.StreamWriter(fs.Filename);
				s.Write(input.Buffer.Text);
				s.Close();
			| _ => ();
		};
		fs.Hide();
	}
}

module SimpleEditor
{ 
	Main() : void
	{
		Application.Init();
		def win = MainWindow();

                // exit application when editor window is deleted
                win.DeleteEvent += fun (_) { Application.Quit () };

                win.ShowAll ();
		Application.Run();
	}
}	
