using System;
using System.Collections.Specialized;

namespace POP3Client
{
	public enum Types
	{
		| TEXT
		| MULTIPART
		| APPLICATION
		| MESSAGE
		| IMAGE
		| AUDIO
		| VIDEO
	}

	public class ContentType
	{

		protected mutable major  : Types;
		protected mutable minor  : string;
		protected mutable data   : string;
		protected mutable extras : StringDictionary;


		public this (parameter : HeaderParameter)
		{
//			Console.WriteLine ("Melon0");
			if (parameter == null) throw ArgumentException () else {};

//			Console.WriteLine ("Melon1");
			mutable parties = parameter.Value.Split ("/".ToCharArray ());

//			Console.WriteLine ("Melon2");
			match (parties[0].ToLower ())
			{
				| "application" => major = Types.APPLICATION;
				| "multipart"   => major = Types.MULTIPART;
				| "image"       => major = Types.IMAGE;
				| "audio"       => major = Types.AUDIO;
				| "video"       => major = Types.VIDEO;
				| "text"        => major = Types.TEXT;
				| _             => Console.WriteLine ("Unknown: " + parameter.Name);
			};

//			Console.WriteLine ("Melon3");
			minor  = parties[1];
//			Console.WriteLine ("Melon4");
			extras = parameter.Additional;
//			Console.WriteLine ("Melon5");
			data   = String.Empty;
//			Console.WriteLine ("Melon6");
		}


		public GetExtraValue (key : string) : string
		{
			if (extras == null) null
			else extras[key];
		}


		public Type : Types
		{
			get { major }
		}
		

		public Add (toAdd : string) : void
		{
			data = data + toAdd + "\r\n";
		}


		private static ToChar (str : string) : char
		{
			mutable hi = 0;
			mutable lo = 0;

			if (str[0] == '\r' && str[1] == '\n') ' '
			else
			{
				hi = ((str[0] :> byte) - ('0' :> byte));
				lo = ((str[1] :> byte) - ('0' :> byte));

				if (hi > 9) hi = ((str[0] :> byte) - ('A' :> byte)) + 10 else {};
				if (lo > 9) lo = ((str[1] :> byte) - ('A' :> byte)) + 10 else {};

				if (hi > 15) hi = ((str[0] :> byte) - ('a' :> byte)) + 10 else {};
				if (lo > 15) lo = ((str[1] :> byte) - ('a' :> byte)) + 10 else {};

				((hi * 16 + lo) :> char);
			};
		}
				
				
		public Format () : string
		{
			mutable result = String.Empty;

			match (major)
			{
				| Types.TEXT =>

					mutable formatTab = data.Split ("=".ToCharArray ());

					result = formatTab[0];

					for (mutable i = 1; i < formatTab.Length; i = i + 1)
					{
						result = result + ContentType.ToChar (formatTab[i].Substring (0, 2)).ToString ();
						result = result + formatTab[i].Substring (2);
					};
				| _ => {};
			};

			result;
		}
				
				
		public override ToString () : string
		{
			minor;
		}

	}
}
