/*
 * The random number generator for the ants simulator.
 * 
 * As described in the problem statement.
 */

namespace Nemerle.Ants
{
  using System;

  public class AntRandom
  {
    public this (seed : uint)
    {
      m_seed = seed;

      for (mutable i = 0; i < 4; ++i)
        TickSeed ();
    }

    public Next () : uint
    {
      def result =
        (m_seed / 65536U) % 16384U;

      TickSeed ();

      result;
    }

    public Next (range : uint) : uint
    {
      Next () % range;
    }

    private TickSeed () : void
    {
      unchecked
      {
        m_seed = m_seed * 22695477U + 1U;
      }
    }

#if TESTING_ANT_RANDOM
    public static Main () : void
    {
      def ar = AntRandom (12345U);

      for (mutable i = 0; i < 100; ++i)
        Console.WriteLine ("{0}", ar.Next ());
    }
#endif

    private mutable m_seed : uint;
  }
}
