
using Nemerle.Collections;
using Nemerle.Compiler;
using Nemerle.Compiler.Parsetree;

class M 
{
  public static mutable Locals : list [string * PExpr];
  
  class StagedMacro : IMacro 
  {
    public Run (_ctx : TypingContext, val : list [SyntaxElement]) : PExpr {
      match (val) {
        | [SyntaxElement.Expression (expr)] =>
          M.Locals = [];
          
          def locals = _ctx.GetLocals ();
          def values = locals.Fold (fun (n : Name, loc : LocalValue, acc) {
            M.Locals = (loc.name, PrettyPrint.TypedTypeToParseTree (loc.ty)) :: M.Locals;
            <[ ($(n : name) : object) :: $acc ]>
          }, <[ [] ]>);
          <[ array [$expr : object, array $values] ]>

        | _ => Util.ice ()
      }
    }

    // not interesting macro stuff (will disappear)
    public CallTransform (l : list [PExpr]) : list [SyntaxElement]
    { List.Map (l, SyntaxElement.Expression); }
    public SyntaxExtension () : string * list [Parser.GrammarElement] * list [int]
    { ("", [], []) }
    public IsTailRecursionTransparent : bool { get { false } }
    public GetName () : string { "stagedmacro" }
    public GetNamespace () : string { "" }
    // not interesting macro stuff
  }

  // analyze given expression and return the new one with
  // our macro's call at the end
  static inject (body : PExpr) : PExpr {
    match (body) {
      | <[ {..$seq } ]> =>
        def (beg, last) = List.DivideLast (seq);
        def last = 
          match (last) {
            // if the last expression in sequence is definition,
            // it must be before our macro and also return value is void then
            | <[ def $_ = $_ ]> | <[ mutable $_ = $_ ]> =>
              <[ $last; stagedmacro (()) ]>
            // pass last expression (return value) to our macro
            | _ => <[ stagedmacro ($last) ]>
          }
        // return enchanced sequence, with our macro as the last expression
        <[ {..$ (beg + [last]) } ]>
      | _ => <[ stagedmacro ($body) ]>
    }
  }
  
  static DoTheStuff (_ : Parsetree.TopDeclaration, env : GlobalEnv) : GlobalEnv {
    MacroRegistry.register_macro (StagedMacro ());
    
    def tb = GlobalEnv.DefineExact (<[ decl: public class A { } ]>);

    def body = <[
      def x = 5;
      def _y = "bla";
      def f = fun (x : System.String) { x };
      x
    ]>;
    
//    def body = Parser.ParseExpr ("{ def x = 5; def y = [1,2]; x }");    
    def whole = inject (body);

    mutable i = -1;    
    def inits = List.FoldLeft (M.Locals, [], fun (x, acc) {
      match (x) {
        | (name, ty) =>
          ++i;          
          <[ def $(name : usesite) = _N_prevs [$(i : int)] :> $ty; ]> :: acc;
      }
    });
    def whole = <[ {.. $(inits + [whole]) } ]>;
    
     PrettyPrint.PrintExpr (None (), whole);
    
    tb.Define (<[ decl:
                 public static Run (_N_prevs : array [System.Object]) : array [System.Object]
                 { $whole }
               ]>);
    tb.Compile ();

    env // simply return what we were given (method signature must match with pipeline)
  }
  
  static Main () : void {
    def prev = array ["bla" : object, 9];
    Locals = [("p1", <[ System.String ]>), ("p2", <[ System.Int32 ]>)];
    
    Message.InitOutput (System.Console.Out);         

    Options.Sources = [""];
    Options.CompileToMemory = true;
    Options.ProgressBar = false;
    
    Passes.LexingPipeline = fun (_) { null };
    Passes.ParsingPipeline = fun (_) { [null] };
    Passes.ScanningPipeline = DoTheStuff;
    Passes.Run ();
    
    def ass = Passes.GeneratedAssembly;
    def meth = ass.GetTypes()[0].GetMethod("Run");
    def ret = meth.Invoke (null, array [prev : object]) :> array [object];
    def result = ret[0];
    def locals = ret[1] :> array [object];

    System.Console.WriteLine (result);
    foreach (x in locals)
      System.Console.WriteLine (x);
    foreach ((name, ty) in Locals)
      System.Console.WriteLine (name + " : " + PrettyPrint.SprintExpr (None (), ty));
  }
}
