using Nemerle.IO;
using System.Console;

[Record]
class Printer[T] {
  public mutable f : T;
  public override ToString () : string
  {
    typeof (T).ToString () + " : " + f.ToString ()
  }
}


module M {

  list_of_objects () : void {
    def print_list (l) {
      try {
        WriteLine (l);
      }
      catch {
        | e => WriteLine (e.Message);
      }
    }

    def lx = [0, "1", 2:object];
    def ly = [0:object, "1", 2:object];

    print_list (lx);
    print_list (ly);
  }

  runner (f : void -> void) : void
  {
    f ()
  }

  xx : long; // W: field `M.xx' is never assigned to
  
  apply (x:object,y:object):object { x :> int + y :> int }
  PassCB (ini : int) : int
  {
    def loop (acc, n) {
      if (n < 0) acc
      else loop (apply (acc, acc), n - 1)
    }
    loop (ini, 5) :> int
  }
  
  
  Main () : void {

    mutable x = (42 : object);
    printf ("%d\n", (x :> int));
    x = 6 * 9;
    printf ("%d\n", (x :> int));
    x = "foo";
    printf ("%s\n", (x :> string));

    mutable y = (420 : object);
    printf ("%d\n", (y :> int));
    
    def f () {
      y = 6 * 9 + 1;
      printf ("%d\n", (y :> int));
      y = "bar";
      printf ("%s\n", (y :> string));
    };

    runner (f);

   def x1 = (1 : object);
   def tab = array [("ala" : object), "kot", x1];
   printf ("%d\n", tab.Length);

   printf ("%s %s %s\n", 1.GetType ().FullName, 42.ToString (), xx.GetType().Name);

   def p1 = Printer (42);
   System.Console.WriteLine (p1);
   p1.f = 43;
   System.Console.WriteLine (p1);

   def p2 = Printer.[object] (42);
   System.Console.WriteLine (p2);
   p2.f = 43;
   System.Console.WriteLine (p2);

    list_of_objects ();

   {
    def f (o : option [object * object])
    {
      System.Console.WriteLine (o);
    }

    def g (x : object * object, y : object * object)
    {
      System.Console.WriteLine (x);
      System.Console.WriteLine (y);
    }

    g (("foo","bar"),(3,4));
    f (Some (1, 2));
   }
    assert (M.PassCB (10) == 640);
  }
}

/*
BEGIN-OUTPUT
42
54
foo
420
55
bar
3
System.Int32 42 Int64
System.Int32 : 42
System.Int32 : 43
System.Object : 42
System.Object : 43
[0, 1, 2]
[0, 1, 2]
(foo, bar)
(3, 4)
Some ((1, 2))
END-OUTPUT
*/
