//
// Test for access modifiers
//

using System;

 public class Tester {

	 static Main () :  void
	 {
		 mutable  a =  A (8);
		 mutable  b =  B (9);

		 b.SetCount (10);
		 Console.WriteLine ("b.Count should be 9: {0}", b.Count);
		 Console.WriteLine ("b [{0}] should return {0}: {1}", 10, b [10]);

		 Console.WriteLine ("a.Message : {0}", a.Message);
		 b.Message = "";
		 Console.WriteLine ("b.Messasge : {0}", b.Message);
	 }

 }

 public class A {

	 protected  mutable  count : int;

	 public this ( count : int)
	 {
		 this.count = count;
	 }

	 public virtual Count : int {
		 get {
			  count;
		 }
		 protected set {
			 count = value;
		 }
	 }

	 public virtual Item [ index : int] : int {
		 get {
			  index;
		 }
	 }

	 public virtual Message : string {
		 get {
			  "Hello Mono";
		 }
	 }

 }

 public class B : A {

	 public this ( count : int)
	 {  base (count);
	 }

	 public override Count : int {
		 protected set { ignore (value);
		 }
	 }

	 public SetCount ( value : int) :  void
	 {
		 Count = value;
	 }

	 public override Item [ index : int] : int {
		 get {
			  base [index];
		 }
	 }

	 public new Message : string {
		 get {
			  "Hello Mono (2)";
		 }
		 internal set { ignore (value);
		 }
	 }

 }
/*
BEGIN-OUTPUT
b.Count should be 9: 9
b [10] should return 10: 10
a.Message : Hello Mono
b.Messasge : Hello Mono (2)
END-OUTPUT
*/
