
namespace Nemerle.Compiler 
{
  module Stats 
  {
    public mutable DoPrintStats = false;
    public mutable PrintTemps = false;

    public mutable AllTypeBuilders : int;
    public mutable FirstClassFunctions : int;
    public mutable FunctionClosures : int;    
    public mutable TimeStarted : int;

    public mutable Temp1 : int;
    public mutable Temp2 : int;
    public mutable Temp3 : int;

    public Reset () : void
    {
      AllTypeBuilders = 0;
      FirstClassFunctions = 0;
      FunctionClosures = 0;
      Temp1 = 0;
      Temp2 = 0;
      Temp3 = 0;
      TimeStarted = System.Environment.TickCount;
    }

    public Run () : void {
      def dump () {
        IO.print ("------------- STATS ---------------\n");
        IO.print ("  AllTypeBuilders:     $AllTypeBuilders\n");
        IO.print ("  FirstClassFunctions: $FirstClassFunctions\n");
        IO.print ("  FunctionClosures:    $FunctionClosures\n");        
        IO.print ("  RealRunningTime:     $(System.Environment.TickCount - TimeStarted)ms\n");
  
        when (Temp1 != 0 || Temp2 != 0 || Temp3 != 0 || PrintTemps) {
          IO.print ("\n");
          IO.print ("  Temp1: $Temp1\n");
          IO.print ("  Temp2: $Temp2\n");
          IO.print ("  Temp3: $Temp3\n");
        }
        IO.print ("------------- END STATS ---------------\n");
      }
      when (DoPrintStats)
        dump ();
    }
  }
}
