/* Definition for debug statements and assertions.

	Copyright (C) 1993-1998 Sebastiano Vigna 
	Copyright (C) 1999-2006 Todd M. Lewis and Sebastiano Vigna

	This file is part of ne, the nice editor.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2, or (at your option) any
	later version.
	
	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.
	
	You should have received a copy of the GNU General Public License along
	with this program; see the file COPYING.  If not, write to the Free
	Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.  */


#ifndef NODEBUG

void __assert(int x, char *expr, char *file, int line);

#define assert(x) { __assert((x), #x, __FILE__, __LINE__); if(!(x)) abort();}

#else

#define assert(ignore)  ((void) 0)

#endif


#ifdef DEBUGPRINTF

#define D(x) x

#else

#define D(x) ;

#endif
