/* $Id: Packed_seqint.hpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqloc.asn'.
 */

#ifndef OBJECTS_SEQLOC_PACKED_SEQINT_HPP
#define OBJECTS_SEQLOC_PACKED_SEQINT_HPP


// generated includes
#include <objects/seqloc/Packed_seqint_.hpp>
#include <objects/seqloc/Na_strand.hpp>
#include <util/range.hpp>


// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CSeq_id;


class NCBI_SEQLOC_EXPORT CPacked_seqint : public CPacked_seqint_Base
{
    typedef CPacked_seqint_Base Tparent;
public:
    typedef CSeq_id                    TId;
    typedef ENa_strand                 TStrand;
    typedef vector< CRange<TSeqPos> >  TRanges;

    // constructor
    CPacked_seqint(void);
    CPacked_seqint(TId& id, const TRanges& ivals,
                   TStrand strand = eNa_strand_unknown);

    // destructor
    ~CPacked_seqint(void);

    // get the length of the pieces
    TSeqPos GetLength(void) const;

    // check start or stop end of location for e_Lim fuzz
    bool IsPartialStart(ESeqLocExtremes ext) const;
    bool IsPartialStop (ESeqLocExtremes ext) const;

    // set / remove e_Lim fuzz on start or stop end
    void SetPartialStart(bool val, ESeqLocExtremes ext);
    void SetPartialStop (bool val, ESeqLocExtremes ext);

    /// check if parts of the seq-loc are missing
    bool IsTruncatedStart(ESeqLocExtremes ext) const;
    bool IsTruncatedStop (ESeqLocExtremes ext) const;

    /// set / remove e_Lim fuzz on start or stop
    /// (tl/tr - indicating removed parts of the seq-loc)
    void SetTruncatedStart(bool val, ESeqLocExtremes ext);
    void SetTruncatedStop (bool val, ESeqLocExtremes ext);

    /// for convenience
    void AddInterval(const CSeq_interval& ival);
    void AddInterval(const CSeq_id& id, TSeqPos from, TSeqPos to,
                     TStrand strand = eNa_strand_unknown);
    void AddIntervals(const CPacked_seqint& ivals);
    void AddIntervals(const Tdata& ivals);

    bool IsSetStrand(EIsSetStrand flag = eIsSetStrand_Any) const;
    ENa_strand GetStrand(void) const;
    bool IsReverseStrand(void) const;
    TSeqPos GetStart(ESeqLocExtremes ext) const;
    TSeqPos GetStop (ESeqLocExtremes ext) const;

    const CSeq_interval* GetStartInt(ESeqLocExtremes ext) const;
    const CSeq_interval* GetStopInt (ESeqLocExtremes ext) const;
    CSeq_interval* SetStartInt(ESeqLocExtremes ext);
    CSeq_interval* SetStopInt (ESeqLocExtremes ext);

    /// Set the strand for all of the location's ranges.
    void SetStrand(ENa_strand strand);
    /// Reset the strand to 'not set'
    void ResetStrand(void);

    /// Flip the strand (e.g. plus to minus)
    void FlipStrand(void);

private:
    // Prihibit copy constructor & assignment operator
    CPacked_seqint(const CPacked_seqint&);
    CPacked_seqint& operator= (const CPacked_seqint&);
};



/////////////////// CPacked_seqint inline methods

// constructor
inline
CPacked_seqint::CPacked_seqint(void)
{
}

inline
bool CPacked_seqint::IsReverseStrand(void) const
{
    return IsReverse(GetStrand());
}

/////////////////// end of CPacked_seqint inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_SEQLOC_PACKED_SEQINT_HPP
