/*
 * NASPRO - NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2009 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _NACORE_ENV_H
#define _NACORE_ENV_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Retrieves the value of an environment variable, returns NULL on failure. If
 * not NULL, the value must be freed using nacore_env_free_var_value().
 *
 * name is the name of the environment variable
 */
char * nacore_env_get_var(const char *name);

/*
 * Frees, if needed, a value returned by nacore_env_get_var().
 *
 * value is the value returned by nacore_env_get_var().
 */
void nacore_env_free_var_value(char *value);

#ifdef __cplusplus
}
#endif

#endif /* !_NACORE_ENV_H */
