--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Exec_Command;

package body Sax.Readers.Commands is

   -------------------
   -- Start_Element --
   -------------------

   procedure Start_Element
     (Handler       : in out Reader;
      Namespace_URI : Unicode.CES.Byte_Sequence := "";
      Local_Name    : Unicode.CES.Byte_Sequence := "";
      Qname         : Unicode.CES.Byte_Sequence := "";
      Atts          : Sax.Attributes.Attributes'Class)
   is
      pragma Unreferenced (Namespace_URI);
      pragma Unreferenced (Local_Name);
      pragma Unreferenced (Atts);
   begin
      Handler.Current_Key_Word := Key_Word'Value (Qname);
      if Handler.Current_Key_Word = Command then
         if Handler.Command_Name /= Null_Unbounded_String or
           Handler.Arguments /= Null_Unbounded_String then
            raise Syntax_Error;
         end if;
      end if;
   end Start_Element;

   -----------------
   -- End_Element --
   -----------------

   procedure End_Element
     (Handler : in out Reader;
      Namespace_URI : Unicode.CES.Byte_Sequence := "";
      Local_Name    : Unicode.CES.Byte_Sequence := "";
      Qname         : Unicode.CES.Byte_Sequence := "")
   is
      pragma Unreferenced (Namespace_URI);
      pragma Unreferenced (Local_Name);
      Key_Word_For_End : Key_Word;
   begin
      Key_Word_For_End := Key_Word'Value (Qname);
      if Key_Word_For_End = Command then
         if Handler.Command_Name = Null_Unbounded_String then
            raise Syntax_Error;
         end if;
         if Handler.Arguments /= Null_Unbounded_String then
            Handler.Result := To_Unbounded_String
              (Exec_Command (To_String (Handler.Command_Name & " " &
                                        Handler.Arguments)));
         else
            Handler.Result := To_Unbounded_String
              (Exec_Command (To_String (Handler.Command_Name)));
         end if;
         Handler.Command_Name := Null_Unbounded_String;
         Handler.Arguments := Null_Unbounded_String;
      end if;
   end End_Element;

   ----------------
   -- Characters --
   ----------------

   function String_Helper (Ch : String) return String;

   procedure Characters
     (Handler : in out Reader;
      Ch      : Unicode.CES.Byte_Sequence)
   is
   begin
      case Handler.Current_Key_Word is
         when Command =>
            raise Syntax_Error;
         when Name =>
            Handler.Command_Name := To_Unbounded_String (Ch);
         when Argument =>
            declare
               New_Ch : constant String := String_Helper (Ch);
            begin
               if Handler.Arguments = Null_Unbounded_String then
                  Handler.Arguments := To_Unbounded_String (New_Ch);
               else
                  Handler.Arguments := Handler.Arguments & " " & New_Ch;
               end if;
            end;
      end case;
   end Characters;

   ------------
   -- Result --
   ------------

   function Result (Handler : Reader) return String is
   begin
      return To_String (Handler.Result);
   end Result;

   function String_Helper (Ch : String) return String is
      Return_String : Unbounded_String := Null_Unbounded_String;
   begin
      for I in Ch'Range loop
         if Ch (I) = ' ' then
            Return_String := Return_String & "\ ";
         else
            Return_String := Return_String & Ch (I);
         end if;
      end loop;
      return To_String (Return_String);
   end String_Helper;

end Sax.Readers.Commands;
