--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Log4ada.Loggers;
with Narval.Configurator.Actors_Description;

package Narval.Communication.Handling is

   procedure Free (Link : in out Link_Access);

   function New_Client_Link
     (Input : Configurator.Actors_Description.Receiver_Descriptor_Type;
      Asker : String;
      Logger : Log4ada.Loggers.Logger_Class_Access)
     return Link_Access;

   function New_Server_Link
     (Output : Configurator.Actors_Description.Sender_Descriptor_Type;
      Logger : Log4ada.Loggers.Logger_Class_Access)
     return Link_Array_Access;

end Narval.Communication.Handling;
