--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Gnat.Sockets;
with Ada.Text_Io;

procedure Test_Protocol is
   use Gnat.Sockets;
   Address  : Sock_Addr_Type;
   Socket   : Socket_Type;
   Channel  : Stream_Access;
begin
   Address.Addr := Addresses (Get_Host_By_Name (Host_Name), 1);
   Address.Port := 10201;
   Create_Socket (Socket);

   Set_Socket_Option
     (Socket,
      Socket_Level,
      (Reuse_Address, True));
   Connect_Socket (Socket, Address);
   Channel := Stream (Socket);
   Ada.Text_Io.Put_Line (String'Input (Channel));
end Test_Protocol;
