#! /usr/bin/perl -w

# rrd2-graph.cgi - Returns an Image from an RRDDB using the ngraph configfile
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller, Marius Heinhttp://www.golem.de/0607/46463.html
# $Id: rrd2-graph.cgi 1558 2007-03-07 12:38:59Z gmueller $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use CGI qw(:standard);
use IO::Handle;
use NagiosGrapher;
use Time::Local;

use vars qw (
  $path
  $rrdtool
  $configfile
  $height
  $width
  $only_graph
  $host
  $service
  $title
  $end
  $start
  @lines
  @values
  @graphs
  %tmp
  @blocks
  @tmp
  $ERR
  %units
  $page_act
  $xml_hash
  $nagios_config
  $type
  @options
  $debug
  $max_length
  $service_title
  $line_end
  $eol
  $repeat
  $image_format
);

my $upper_limit = undef;
my $lower_limit = undef;

my $q      = new CGI;
my $params = $q->Vars;

# CGI Query Params
$host    = param("host");
$service = param("service");
$title   = param("title");
$end     = param("end");
$start   = param("start");

$width      = param("width");
$height     = param("height");
$page_act   = param("act_page");
$only_graph = param("only-graph");

$type = uc( param("type") ) if ( defined( param("type") ) );
$type = 'AVERAGE' unless ( defined($type) );

$image_format = uc( param('imageformat') );
if ( $image_format =~ m/^(PNG|SVG|EPS|PDF)$/ ) {
	$image_format = $1;
}
else {
	$image_format = 'PNG';
}

# Configuration
my $ng = NagiosGrapher::getInstance();

$path          = $ng->get_ngraphercfg_value('rrdpath');
$configfile    = $ng->get_ngraphercfg_value('ngraphcfg');
$nagios_config = $ng->get_ngraphercfg_value('nagios_config');

# makes some error in the Apache LOG ...
# undef $page_act if (length($page_act) <= 0);

if (   !$ng->AuthCheck( $nagios_config, $host, $ENV{'REMOTE_USER'} )
	&& !( $ng->get_ngraphercfg_value('use_authentication') =~ m/no/i )
	&& $ng->get_use_auth
	&& !( $ng->get_authorized_for_all_services =~ m/$ENV{'REMOTE_USER'}/ ) )
{
	$ng->error_image(
		    message => "Sorry the user \""
		  . $ENV{'REMOTE_USER'}
		  . "\" is not allowed to view this graph!\nYour Nagios System",

		width => $width,
	);
	exit 0;
}

# Setting up default values...
$start = "--start=" . $start if ( defined($start) && length($start) > 0 );

# $end = time() if (!$end);
$end = "--end=" . $end if ( defined($end) && length($end) > 0 );

$height = 255 if ( !defined($height) || $height eq "" );
$width  = 595 if ( !defined($width)  || $width  eq "" );

@options = ();

# Adding some cool options ...
my $rrd_background = $ng->get_ngraphercfg_value('rrd_color_background');
push @options, '-cBACK#' . $rrd_background if ( defined $rrd_background );

my $rrd_font = $ng->get_ngraphercfg_value('rrd_color_font');
push @options, '-cFONT#' . $rrd_font if ( defined $rrd_font );

my $rrd_arrow = $ng->get_ngraphercfg_value('rrd_color_arrow');
push @options, '-cARROW#' . $rrd_arrow if ( defined $rrd_arrow );

my $rrd_frame = $ng->get_ngraphercfg_value('rrd_color_frame');
push @options, '-cFRAME#' . $rrd_frame if ( defined $rrd_frame );

my $rrd_grid = $ng->get_ngraphercfg_value('rrd_color_grid');
push @options, '-cGRID#' . $rrd_grid  if ( defined $rrd_grid );
push @options, '-cMGRID#' . $rrd_grid if ( defined $rrd_grid );

my $rrd_canvas = $ng->get_ngraphercfg_value('rrd_color_canvas');
push @options, '-cCANVAS#' . $rrd_canvas if ( defined $rrd_canvas );

my $rrd_shadea = $ng->get_ngraphercfg_value('rrd_color_shadea');
push @options, '-cSHADEA#' . $rrd_shadea if ( defined $rrd_shadea );

my $rrd_shadeb = $ng->get_ngraphercfg_value('rrd_color_shadeb');
push @options, '-cSHADEB#' . $rrd_shadeb if ( defined $rrd_shadeb );

push @options, '--only-graph'
  if ( defined $only_graph && $only_graph =~ /TRUE/i );

# Setting up some date as comment.
my ( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday ) =
  localtime( time() );

# Checking if it is a Multigraph ....
if ( $ng->get_nmgrapherdef($service) ) {
	$max_length = 10;
	$line_end   = '';

	$ng->time_need( type => 'start' );
	my (@dsnames);
	my $graph_type = '';
	my %nmgraph    = $ng->get_nmgrapherdef($service);
	if ( $nmgraph{colors} ) {
		$ng->set_colors( $nmgraph{colors} );
	}

	# TODO: Sortierung in die funktion implementieren
	# --
	# Geht nicht, die Hashkeys kommen immer in beliebiger Reihenfolge,
	# d.h. die Keys knnen nur in der Ausgabe sortiert werden.
	$xml_hash = $ng->get_ngrapherxml();

	for my $host ( sort keys %{ $xml_hash->{host} } ) {
		my $val = $xml_hash->{host}{$host};

		if ( $host =~ m/$nmgraph{hosts}/ ) {
			while ( my ( $key, $service ) = each( %{ $val->{service} } ) ) {
				if ( $service->{service_name} =~ m/$nmgraph{services}/ ) {
					@blocks =
					  $ng->get_ngrapherdef( $service->{service_name}, 'graph' );
					@blocks = reverse(@blocks)
					  if ( defined( $nmgraph{order} )
						&& $nmgraph{order} =~ m/reverse/i );

					foreach (@blocks) {

						next
						  if ( exists( $_->{graph_value} )
							&& exists( $nmgraph{graph_values} )
							&& !(
								$_->{graph_value} =~ m/$nmgraph{graph_values}/ )
							&& $nmgraph{graph_values} ne '' );

						$units{ $_->{service_name} } = $_->{graph_units}
						  unless ( exists( $units{ $_->{service_name} } ) );

						if ( exists( $_->{graph_upper_limit} ) ) {
							$upper_limit = $_->{graph_upper_limit}
							  if ( $_->{graph_upper_limit} > $upper_limit || $upper_limit == undef );
						}
						if ( exists( $_->{graph_lower_limit} ) ) {
							$lower_limit = $_->{graph_lower_limit}
							  if ( $_->{graph_lower_limit} < $lower_limit || $lower_limit == undef );
						}

						my $legend;
						if ( defined( $nmgraph{graph_legend} ) ) {
							$legend = $nmgraph{graph_legend};
							$legend =~
							  s/\$SERVICENAME\$/$service->{service_name}/i;
							$legend =~ s/\$HOSTNAME\$/$host/i;

						}
						else {
							$legend = '[' . $host . '] ' . $_->{graph_legend},;
						}

						$service_title = $ng->fill_text( $legend, $max_length );
						$service_title =~ s/:/\\:/;

						my $dsname = "x" . $ng->get_random_letters(10);
						my $color  = $ng->get_next_color();

						# bergeben der Linebreite
						if ( $nmgraph{graph_type} =~ m/line(\d)*/i ) {
							my $linewidth = $1;
							$linewidth = "1" if ( $linewidth eq "" );
							$graph_type = 'LINE' . $linewidth;
							push @values,
							  'DEF:' . $dsname . '=' . $path . $host . '/'
							  . $service->{rrd_file} . ':'
							  . $_->{graph_value} . ':'
							  . $type;

							if ( defined( $nmgraph{graph_max_value} ) ) {
								push @values,
								  'CDEF:c' . $dsname . '=' . $dsname . ","
								  . $nmgraph{graph_max_value} . ",LT,"
								  . $dsname
								  . ",UNKN,IF";
								$dsname = 'c' . $dsname;
							}

							push @graphs,
							  $graph_type . ':' . $dsname . $color . ':'
							  . $service_title
							  . $line_end;
						}
						elsif ( $nmgraph{graph_type} =~ m/stack/i ) {
							$graph_type = 'AREA';
							$graph_type = "STACK" if ( scalar(@graphs) >= 1 );
							push @dsnames, $dsname;
							push @values,
							  'DEF:' . $dsname . '=' . $path . $host . '/'
							  . $service->{rrd_file} . ':'
							  . $_->{graph_value} . ':'
							  . $type;
							push @graphs,
							  $graph_type . ':' . $dsname . $color . ':'
							  . $service_title
							  . $line_end;
						}
						elsif ( $nmgraph{graph_type} =~ m/area/i ) {
							$graph_type = 'AREA';
							push @values,
							  'DEF:' . $dsname . '=' . $path . $host . '/'
							  . $service->{rrd_file} . ':'
							  . $_->{graph_value} . ':'
							  . $type;

							my $old_ds = $dsname;
							$dsname = $ng->get_random_letters(10);

							push @values, 'CDEF:' . $dsname . '=' . $old_ds;

							push @graphs,
							  $graph_type . ':' . $old_ds . $color . ':'
							  . $service_title
							  . $line_end;
							push @graphs, 'LINE1' . ':' . $dsname . '#000000';
						}

					}
				}
			}
		}
	}

	if ( $nmgraph{graph_type} =~ m/stack/i ) {
		my $cdef = $dsnames[0] . ',';
		shift(@dsnames);
		$cdef .= join( ',+,', @dsnames ) . ',+';

		push @values, 'CDEF:' . 'sum1' . '=' . $cdef;
		push @graphs, 'LINE1' . ':' . 'sum1' . '#000000';
	}

	if ( exists( $nmgraph{graph_upper_limit} ) ) {
		$upper_limit = $nmgraph{graph_upper_limit}
		  if ( $nmgraph{graph_upper_limit} > $upper_limit || $upper_limit == undef );
	}
	if ( exists( $nmgraph{graph_lower_limit} ) ) {
		$lower_limit = $nmgraph{graph_lower_limit}
		  if ( $nmgraph{graph_lower_limit} < $lower_limit || $lower_limit == undef );
	}

	if ( defined($upper_limit) ) {
		push @options, '--upper-limit=' . $upper_limit;
	}
	if ( defined($lower_limit) ) {
		push @options, '--lower-limit=' . $lower_limit;
	}
	push @graphs, 'COMMENT:\l';

	$ng->time_need(
		type => 'stop',
		msg  => $title . ' creating multigraph def\'s'
	);

	$ng->time_need( type => 'start' );

	# Adding VLINES
	$ng->MakeVlines( $start, \@graphs, \@options, $width, )
	  unless ($only_graph);

	my %args = (
		'params'      => $params,
		'imageformat' => $image_format,
		'options'     => \@options,
		'height'      => $height,
		'width'       => $width,
		'start'       => $start,
		'end'         => $end,
		'title'       => "MultiGraph: " . $nmgraph{service_name},
		'vertical'    => join( ' / ', values(%units) ),
		'values'      => \@values,
		'graphs'      => \@graphs,
	);

	$ng->call_hook(
		ARGSRef => \%args,
		Host    => $host,
		Service => $service,
		Type    => 'before_imagemultigraph',
	);

	# Push the graph to STDOUT
	delete $args{'params'};
	$ERR = $ng->graph_image(%args);

	#$ERR = $ng->graph_image(
	#	'imageformat' => $image_format,
	#	'options'     => \@options,
	#	'height'      => $height,
	#	'width'       => $width,
	#	'start'       => $start,
	#	'title'       => "MultiGraph: " . $nmgraph{service_name},
	#	'vertical'    => join( ' / ', values(%units) ),
	#	'values'      => \@values,
	#	'graphs'      => \@graphs,
	#);

	$ng->time_need( type => 'stop', msg => $title . ' drawing multigraph' );
}
else {
	$max_length = 0;
	$line_end   = '';

	$ng->time_need( type => 'start' );

	# Parsing the Array...
	@blocks = $ng->get_ngrapherdef($service);

	# Reading XML from index file...
	$xml_hash = $ng->get_ngrapherxml();

	# fetch the data...
	if ( scalar(@blocks) > 0 ) {

		foreach (@blocks) {

			# Paging
			# Deprecated: try only to import the DEF's but no graph ...
			# next if ( $page_act && !( $_->{page} eq $page_act ) );

			# Setting up the servicetitle
			if ( exists( $_->{graph_legend} ) && $_->{graph_legend} ) {

				# Override some variables through config options
				my $new_line_end =
				  exists( $_->{graph_legend_eol} )
				  ? $ng->format_eol( $_->{graph_legend_eol} )
				  : $line_end;
				my $new_max_length =
				  exists( $_->{graph_legend_max} )
				  ? $_->{graph_legend_max}
				  : $max_length;

				$service_title =
				    $ng->fill_text( $_->{graph_legend}, $new_max_length )
				  . $new_line_end;
				$service_title =~ s/:/\\:/;
			}
			else {
				$service_title = '';
			}

			if ( exists( $_->{graph_upper_limit} ) ) {
				$upper_limit = $_->{graph_upper_limit}
				  if ( $_->{graph_upper_limit} > $upper_limit || $upper_limit == undef );
			}
			if ( exists( $_->{graph_lower_limit} ) ) {
				$lower_limit = $_->{graph_lower_limit}
				  if ( $_->{graph_lower_limit} < $lower_limit || $lower_limit == undef );
			}

			# Adding real ds
			push( @values,
				    "DEF:"
				  . $_->{graph_value}
				  . "=$path"
				  . "$host/"
				  . $xml_hash->{host}->{$host}->{service}->{$service}
				  ->{rrd_file} . ":" . $_->{graph_value} . ":$type" )
			  unless ( exists( $_->{type} )
				&& $_->{type} =~ /cdef|gprint|hrule|vdef|tick|comment/i );

			unless (
				( exists( $_->{hide} ) && $_->{hide} =~ /yes/i )
				|| ( exists( $_->{type} )
					&& $_->{type} =~ /cdef|gprint|hrule|vdef|tick|comment/i
					|| $page_act
					&& !( $_->{page} eq $page_act || $page_act eq "-ALL" ) )
			  )
			{
				push( @graphs,
					    $_->{rrd_plottype} . ":"
					  . $_->{graph_value} . "#"
					  . $_->{rrd_color} . ":"
					  . $service_title );
			}

			# Adding CDEFs
			if ( exists( $_->{type} ) && $_->{type} =~ /cdef/i ) {
				push( @values,
					"CDEF:" . $_->{graph_value} . "=" . $_->{graph_calc} );

				unless ( ( exists( $_->{hide} ) && $_->{hide} =~ /yes/i )
					|| $page_act
					&& !( $_->{page} eq $page_act || $page_act eq "-ALL" ) )
				{
					push( @graphs,
						    $_->{rrd_plottype} . ":"
						  . $_->{graph_value} . "#"
						  . $_->{rrd_color} . ":"
						  . $service_title );
				}
			}

			# Adding VDEFs
			if ( exists( $_->{type} ) && $_->{type} =~ /vdef/i ) {
				push( @values,
					'VDEF:' . $_->{graph_value} . '=' . $_->{graph_calc} );

				unless ( exists( $_->{hide} ) && $_->{hide} =~ /yes/i
					|| $page_act
					&& !( $_->{page} eq $page_act || $page_act eq "-ALL" ) )
				{
					push( @graphs,
						    $_->{rrd_plottype} . ':'
						  . $_->{graph_value} . '#'
						  . $_->{rrd_color} . ':'
						  . $service_title );
				}
			}

			# Adding TICKs
			if ( exists( $_->{type} ) && $_->{type} =~ /tick/i ) {
				unless ( exists( $_->{hide} ) && $_->{hide} =~ /yes/i
					|| $page_act
					&& !( $_->{page} eq $page_act || $page_act eq "-ALL" ) )
				{
					push( @graphs,
						    'TICK:'
						  . $_->{graph_calc} . '#'
						  . $_->{rrd_color} . ':'
						  . $_->{tick_fraction} . ':'
						  . $service_title );
				}
			}

			# Adding SHIFTs
			if ( exists( $_->{type} ) && $_->{type} =~ /shift/i ) {
				unless ( exists( $_->{hide} ) && $_->{hide} =~ /yes/i
					|| $page_act
					&& !( $_->{page} eq $page_act || $page_act eq "-ALL" ) )
				{
					push( @graphs,
						    'SHIFT:'
						  . $_->{graph_calc} . '#'
						  . $_->{rrd_color} . ':'
						  . $_->{shift_offset} );
				}
			}

			# Adding GPRINTs
			if ( exists( $_->{type} ) && $_->{type} =~ /gprint/i ) {

				unless ( exists( $_->{hide} ) && $_->{hide} =~ /yes/i
					|| $page_act
					&& !( $_->{page} eq $page_act || $page_act eq "-ALL" ) )
				{

					# parsing the description
					my $description = $_->{print_description};
					$description =~ s/:/\\:/;

					# setting up end-of-line
					$eol = '';
					if ( exists( $_->{print_eol} ) ) {
						$eol = $ng->format_eol( $_->{print_eol} );
					}

					$repeat = 1;
					$repeat = $_->{print_repeat} + 1
					  if ( exists( $_->{print_repeat} ) );

					for ( my $i = 0 ; $i < $repeat ; $i++ ) {
						push( @graphs,
							    "GPRINT:"
							  . $_->{print_source} . ":"
							  . uc( $_->{print_function} ) . ":"
							  . $description
							  . $_->{print_format}
							  . $eol );
					}
				}
			}

			# Adding Comments
			if ( exists( $_->{type} ) && $_->{type} =~ /comment/i ) {

				unless ( exists( $_->{hide} ) && $_->{hide} =~ /yes/i
					|| $page_act
					&& !( $_->{page} eq $page_act || $page_act eq "-ALL" ) )
				{

					# Prepare the comment
					my $comment = '';
					if ( exists( $_->{print_description} ) ) {
						$comment = $_->{print_description};
						$comment =~ s/:/\\:/;
					}

					# Prepare end-of-line
					$eol = '';
					if ( exists( $_->{print_eol} ) ) {
						$eol = $ng->format_eol( $_->{print_eol} );
					}
					$repeat = 1;
					$repeat = $_->{print_repeat} + 1
					  if ( exists( $_->{print_repeat} ) );

					for ( my $i = 0 ; $i < $repeat ; $i++ ) {
						push( @graphs, 'COMMENT:' . $comment . $eol );
					}
				}
			}

			# Adding HRULEs
			if ( exists( $_->{type} ) && $_->{type} =~ /hrule/i ) {
				unless ( exists( $_->{hide} ) && $_->{hide} =~ /yes/i
					|| $page_act
					&& !( $_->{page} eq $page_act || $page_act eq "-ALL" ) )
				{
					push( @graphs,
						"HRULE:" . $_->{hrule_value} . "#" . $_->{rrd_color} );
				}
			}

			unless ( exists( $_->{type} ) && $_->{type} =~ /gprint/i ) {
				if (
					   exists( $_->{graph_units} )
					&& $_->{graph_units} ne ''
					&& ( !$page_act
						|| ( $_->{page} eq $page_act || $page_act eq "-ALL" ) )
				  )
				{

					$units{ $_->{graph_units} } = $_->{graph_units}
					  unless ( exists( $units{ $_->{graph_units} } ) );
				}
			}
		}
	}

	if ( defined($upper_limit)) {
		push @options, '--upper-limit=' . $upper_limit;
	}
	if ( defined($lower_limit) ) {
		push @options, '--lower-limit=' . $lower_limit;
	}

	# VLINES
	$ng->MakeVlines( $start, \@graphs, \@options, $width, )
	  unless ($only_graph);

	$ng->time_need( type => 'stop', msg => $title . ' creating graph def\'s' );

	my %args = (
		'params'      => $params,
		'imageformat' => $image_format,
		'options'     => \@options,
		'height'      => $height,
		'width'       => $width,
		'start'       => $start,
		'end'         => $end,
		'title'       => "$host("
		  . $xml_hash->{host}->{$host}->{service}->{$service}->{service_title}
		  . ") - $title Graph",
		'vertical' => join( ' / ', values(%units) ),
		'values'   => \@values,
		'graphs'   => \@graphs,
	);

	$ng->call_hook(
		ARGSRef => \%args,
		Host    => $host,
		Service => $service,
		Type    => 'before_imagegraph',
	);

	$ng->time_need( type => 'start' );

	# Push the image to STDOUT

	delete $args{'params'};

	$ERR = $ng->graph_image(%args);

	#$ERR = $ng->graph_image(
	#	'imageformat' => $image_format,
	#	'options'     => \@options,
	#	'height'      => $height,
	#	'width'       => $width,
	#	'start'       => $start,
	#	'title'       => "$host("
	#	  . $xml_hash->{host}->{$host}->{service}->{$service}->{service_title}
	#	  . ") - $title Graph",
	#	'vertical' => join( ' / ', values(%units) ),
	#	'values'   => \@values,
	#	'graphs'   => \@graphs,
	#);

	$ng->time_need( type => 'stop', msg => $title . ' drawing graph' );
}

if ($ERR) {
	my $msg;
	my $date = sprintf(
		"[%02d\:%02d/%04d-%02d-%02d]",
		$hour, $min, $year + 1900,
		$mon + 1, $mday
	);
	$msg .= "Some error occured:\n";
	$msg .= "~~~~~~~~~~~~~~~~~~~\n\n";
	$msg .= "RRD Error: $ERR\n";
	$msg .= "Options:\n";
	foreach (@options) {
		$msg .= "  $_\n";
	}
	$msg .= "Values:\n";
	foreach (@values) {
		$msg .= "  $_\n";
	}
	$msg .= "\nGraphs:\n";
	foreach (@graphs) {
		$msg .= "  $_\n";
	}
	$msg .= "\n$date\n";
	$ng->error_image( message => $msg, width => $width );
}

# Default exit and return true
exit(0);

1;
