#!/usr/bin/perl -w

# Generic.pm - the default hook library.
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller, Marius Hein
# $Id: Generic.pm 1279 2006-06-19 15:02:15Z mhein $

#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# $Id: Generic.pm 1279 2006-06-19 15:02:15Z mhein $

package NagiosGrapher::Hooks::Generic;
use NagiosGrapher;

use vars qw (
	%TYPES
	@ISA
);

# The different hookup types,
# set in the init sub in the child class.
%TYPES = (
	'before_serviceext' => 1,
	'before_rrdupdate' => 1,
	'before_imagegraph' => 1,
	'before_imagemultigraph' => 1,
);

# constructor
sub new {
  my $package = shift;

  $ng = NagiosGrapher::getInstance();

  my $self = bless {
	    NagiosGrapher => $ng,

	    Values => undef,
	    Service => undef,
	    Host => undef,

	    Types => [],
  }, $package;

  return $self;
}

# Set the types, multiple values allowed
sub SetTypes {
	my $self = shift;
	foreach my $Type (@_) {
		push @{ $self->{Types} }, $Type
			if (exists $NagiosGrapher::Hooks::Generic::TYPES{$Type});
	}
}

# Check if the right type is set.
# called from NagiosGrapher.pm
sub CheckType {
	my $self = shift;
	my ($type) = @_;

	foreach (@{$self->{Types}}) {
		return 1 if ($_ eq $type);
	}

	return;
}

# The init sub.
sub init {
	my $self = shift;
	my %args = (
		Values => undef,
		Service => undef,
		Host => undef,

		@_
	);

	$self->{Values} = $args{'Values'};
	$self->{Service} = $args{'Service'};
	$self->{Host} = $args{'Host'};

	return 1;
}

# Customized log function
sub print_log {
	my $self = shift;
	my ($msg) = @_;

	$self->NG->print_log(sprintf("HOOKMSG: %s", $msg))
		if ($self->NG->get_log_level & $NagiosGrapher::LOG_HOOK);

	return 1;
}

# Accessor methods

sub NG {
	my $self = shift;
	return $self->{NagiosGrapher};
}

sub Values {
	my $self = shift;
	return $self->{Values};
}

sub Types {
	my $self = shift;
	return $self->{Types};
}

sub Service {
	my $self = shift;
	return $self->{Service};
}

sub Host {
	my $self = shift;
	return $self->{Host};
}

# Methods to inherit ...
sub prepare {
	return 1;
}

sub commit {
	return 1;
}

sub cleanup {
	return 1;
}

1;