#!/usr/bin/perl

use strict;
use CGI qw(:standard);
use HTML::Template;
#use Config::Simple; 

require includes;

my $device = param("device");

my $content = "<div id=\"corner\">
If you don't know what values to use, the following are a good starting point for most devices:<br /><br />
codec=mpeg4<br />
sizeY=240<br />
sizeX=320<br />
aspect=4:3<br />
audioBR=192kb<br />
videoBR=600kb
</div> 
<form action=\"save_setup.cgi\" method=\"post\"><p>
<input type=\"hidden\" id=\"device\" name=\"device\" value=\"$device\" />
Title: <input type=\"text\" id=\"title\" name=\"title\" value=\"\" />&nbsp;<span class=\"red\">*</span><br />";

my $template = HTML::Template->new(filename => 'template/template.tmpl');

if($device eq "custom"){
        $content .= "FFmpeg Arguments: ffmpeg -i &lt;input file&gt;&nbsp;<input type=\"text\" id=\"args\" name=\"args\" value=\"\" />&nbsp;<span class=\"red\">*</span>&nbsp;&lt;output file&gt;<br />
        File Extension: <input type=\"text\" id=\"extension\" name=\"extension\" value=\"\" /><br />";
}
elsif($device eq "mp3"){
	$content .= "Audio Bitrate: <input type=\"text\" id=\"audioBR\" name=\"audioBR\" value=\"\" />&nbsp;<span class=\"red\">*</span><br />";
}
elsif($device eq "symlink"){
	$content .= "Symlinks will be created and linked to your original recordings.";
}
else{
	$content .= "Codec: <select id=\"codec\" name=\"codec\">
	<option value=\"mpeg4\">mpeg4</option>
	<option value=\"xvid\">xvid</option>
	<option value=\"h264\">h.264</option>
	</select>&nbsp;<span class=\"red\">*</span><br />
	Size: <input type=\"text\" id=\"sizeX\" name=\"sizeX\" value=\"\" />&nbsp;<span class=\"red\">*</span>&nbsp;X&nbsp;
	<input type=\"text\" id=\"sizeY\" name=\"sizeY\" value=\"\" />&nbsp;<span class=\"red\">*</span><br />
	Aspect: <input type=\"text\" id=\"aspect\" name=\"aspect\" value=\"\" />&nbsp;<span class=\"red\">*</span><br />
	Audio Bitrate: <input type=\"text\" id=\"audioBR\" name=\"audioBR\" value=\"\" />&nbsp;<span class=\"red\">*</span><br />
	Video Bitrate: <input type=\"text\" id=\"videoBR\" name=\"videoBR\" value=\"\" />&nbsp;<span class=\"red\">*</span><br />
	Delete Period: <input type=\"text\" id=\"deletePeriod\" name=\"deletePeriod\" value=\"\" /><br />
	Podcast Name: <input type=\"text\" id=\"podcastName\" name=\"podcastName\" value=\"\" /><br />
	Deinterlace: <input type=\"checkbox\" id=\"deinterlace\" name=\"deinterlace\" value=\"1\" /><br />
	Remove Commercials: <input type=\"checkbox\" id=\"removeCommercials\" name=\"removeCommercials\" value=\"1\" /><br />
	<br /><br />
	- Addition Tweaks -<br /><br />
	Audio Channels: <input type=\"text\" id=\"audioChannels\" name=\"audioChannels\" value=\"\" />&nbsp;* May help with dvb recordings<br />
	Muti-threading: <input type=\"checkbox\" id=\"threads\" name=\"threads\" value=\"1\" /><br />";
}

$content .= "<br />&nbsp;<span class=\"red\">* Are required</span>
<br /><input type=\"submit\" id=\"submit\" name=\"submit\" value=\"Submit\" /></p></form>";

$template->param(CONTENT => $content);
$template->param(LOCATION => "setup");

print generateContentType(), $template->output;
exit(0);
