## -*- coding: utf-8 -*-
#
# «roles» - MCC System Role selector plugin
#
# Copyright (C) 2009, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuControlCentre.plugin import MCCPlugin
from gtk import RadioButton

from mythbuntu_common.dictionaries import *

class SystemRolesPlugin(MCCPlugin):
    """A tool for adjusting the role of a system"""

    def __init__(self):
        #Initialize parent class
        information = {}
        information["name"] = "System Roles"
        information["icon"] = "gnome-monitor"
        information["ui"] = "tab_system_roles"
        MCCPlugin.__init__(self,information)

    def captureState(self):
        """Determines the state of the items on managed by this plugin
           and stores it into the plugin's own internal structures"""
        #We can't really represent no backend or no frontend well yet
        self.no_back=True
        self.no_front=True

        #Dictionaries
        self.dictionary_state={}
        for list in get_role_dictionary(self), \
                    get_diskless_dictionary(self), \
                    get_desktop_dictionary(self):
            for item in list:
                self.dictionary_state[list[item]]=self.query_installed(item)
                if "backend" in item and self.dictionary_state[list[item]]:
                    self.no_back=False
                elif "frontend" in item and self.dictionary_state[list[item]]:
                    self.no_front=False

        #corner case
        if self.dictionary_state[self.primary_backend_radio]:
            self.dictionary_state[self.secondary_backend_radio]=False

    def applyStateToGUI(self):
        """Takes the current state information and sets the GUI
           for this plugin"""
        #Load the detected dictionary
        for item in self.dictionary_state:
            if self.dictionary_state[item]:
                item.set_active(True)

        #In case we don't have a front or back role
        self.no_backend_radio.set_active(self.no_back)
        self.no_frontend_radio.set_active(self.no_front)

    def compareState(self):
        """Determines what items have been modified on this plugin"""
        #Prepare for state capturing
        MCCPlugin.clearParentState(self)

        #Installable items
        for list in get_diskless_dictionary(self), \
                    get_desktop_dictionary(self):
            for item in list:
                if list[item].get_active() != self.dictionary_state[list[item]]:
                    if list[item].get_active():
                        self._markInstall(item)
                    else:
                        self._markRemove(item)

        #backend unfortunately totally a corner case
        if self.primary_backend_radio.get_active() != self.dictionary_state[self.primary_backend_radio]:
            if self.primary_backend_radio.get_active():
                self._markInstall('mythtv-backend-master')
            else:
                self._markRemove('mythtv-backend-master')
                if not self.secondary_backend_radio.get_active():
                    self._markRemove('mythtv-backend')
        elif self.secondary_backend_radio.get_active() != self.dictionary_state[self.secondary_backend_radio]:
            if self.secondary_backend_radio.get_active():
                self._markInstall('mythtv-backend')
            else:
                self._markRemove('mythtv-backend')

        if self.frontend_radio.get_active() != self.dictionary_state[self.frontend_radio]:
            if self.frontend_radio.get_active():
                self._markInstall('mythtv-frontend')
            else:
                self._markRemove('mythtv-frontend')


