# -*- coding: utf-8 -*-
#
# «dictionaries» - Manage list of all widget -> package matching
#
# This script:
# Copyright (C) 2008, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

####################
#Theme dictionaries: these are for managing a list of all possible themes
####################
def get_official_theme_dictionary(self):
    list= {
        "mythtv-theme-gray-osd": self.theme_gray_osd,                          \
        "mythtv-theme-isthmus": self.theme_isthmus,                            \
        "mythtv-theme-iulius": self.theme_iulius,                              \
        "mythtv-theme-iulius-osd": self.theme_iulius_osd,                      \
        "mythtv-theme-minimalist-wide": self.theme_minimalist_wide,            \
        "mythtv-theme-mythcenter": self.theme_mythcenter,                      \
        "mythtv-theme-mythcenter-wide": self.theme_mythcenter_wide,            \
        "mythtv-theme-retro": self.theme_retro,                                \
        "mythtv-theme-retro-osd": self.theme_retro_osd,                        \
        "mythtv-theme-titivillus": self.theme_titivillus,                      \
        "mythtv-theme-titivillus-osd": self.theme_titivillus_osd }
    return list

def get_community_theme_dictionary(self):
    list= {
        "mythtv-theme-blootube": self.theme_blootube,                          \
        "mythtv-theme-blootube-osd": self.theme_blootube_osd,                  \
        "mythtv-theme-blootube-wide": self.theme_blootube_wide,                \
        "mythtv-theme-blootubelite-wide": self.theme_blootube_lite_wide,       \
        "mythtv-theme-glass-wide": self.theme_glass_wide,                      \
        "mythtv-theme-mythbuntu": self.theme_mythbuntu,                        \
        "mythtv-theme-neon-wide": self.theme_neon_wide,                        \
        "mythtv-theme-projectgrayhem": self.theme_project_grayhem,             \
        "mythtv-theme-projectgrayhem-osd": self.theme_project_grayhem_osd,     \
        "mythtv-theme-projectgrayhem-wide": self.theme_project_grayhem_wide }
    return list

####################
#Plugin dictionaries: these are for managing a list of all possible plugins
####################
def get_frontend_plugin_dictionary(self):
    list = {
        "mytharchive": self.mytharchive_checkbox,                             \
        "mythbrowser": self.mythbrowser_checkbox,                             \
        "mythcontrols": self.mythcontrols_checkbox,                           \
        "mythflix": self.mythflix_checkbox,                                   \
        "mythgame": self.mythgame_checkbox,                                   \
        "mythgallery": self.mythgallery_checkbox,                             \
        "mythmovies": self.mythmovies_checkbox,                               \
        "mythmusic": self.mythmusic_checkbox,                                 \
        "mythnews": self.mythnews_checkbox,                                   \
        "mythstream":self.mythstream_checkbox,                                \
        "mythphone": self.mythphone_checkbox,                                 \
        "mythvideo": self.mythvideo_checkbox,                                 \
        "mythweather": self.mythweather_checkbox }
    return list

def get_backend_plugin_dictionary(self):
    return { "mythweb": self.mythweb_checkbox }

#Other dictionaries: these are for managing a list of all other apps
def get_desktop_dictionary(self):
    list = {
        "ubuntu-desktop": self.ubuntu_desk_check,                             \
        "xubuntu-desktop": self.xubuntu_desk_check,                           \
        "kubuntu-desktop": self.kubuntu_desk_check }
    return list

def get_media_app_dictionary(self):
    list = {
        "mplayer": self.mplayer_checkbox,                                     \
        "xine-ui": self.xine_checkbox,                                        \
        "vlc":  self.vlc_checkbox }
    return list

def get_nonfree_dictionary(self):
    list = {
        "libdvdcss2": self.enable_libdvdcss2,                                 \
        "ffmpeg": self.enable_ffmpeg,                                         \
        "w64codecs": self.enable_w64codecs,                                   \
        "w32codecs": self.enable_w32codecs }
    return list

def get_services_dictionary(self):
    list = {
        "x11vnc": self.enablevnc,                                         \
        "samba": self.enablesamba,                                            \
        "nfs-kernel-server": self.enablenfs,                                  \
        "openssh-server": self.enablessh,                                     \
        "mysql-server": self.enablemysql }
    return list
    
def get_diskless_dictionary(self):
	list = {
		"mythbuntu-diskless-server": self.diskless_server_install,          \
        "dhcp3-server": self.diskless_server_dhcp }
	return list
