#!/usr/bin/env python
## -*- coding: utf-8 -*-
#
#
# Copyright (C) 2011, Thomas Mashos, for Mythbuntu
#
#
# Mythbuntu-bare is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################
import os
import tarfile
import time
import shutil
import subprocess
import platform
import ConfigParser
import logging
import datetime

logger = logging.getLogger('mythbuntu-bare')
hdlr = logging.FileHandler('/var/log/mythbuntu-bare-client.log')
formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
hdlr.setFormatter(formatter)
logger.addHandler(hdlr) 
logger.setLevel(logging.WARNING)

ACTOR="<mythbackup> "

class Backup():

    def backup_job(self, BackupDB=True, Location="/var/lib/mythtv/bare-client/"):
        """Backup all the files"""
        logger.info(ACTOR+'Starting backup job')
        ## Check backup directory exists
        if not os.path.exists(Location):
            os.makedirs(Location)
            logger.info(ACTOR+'Creating backup directory at '+str(Location))
        ## Array of files to Backup
        BACKUPFILES = [
        "/etc/mythtv/config.xml",
        "/etc/mythtv/mysql.txt",
        "/etc/lirc/lircd.conf",
        "/etc/lirc/hardware.conf",
        "/etc/hostname",
        "/etc/hosts",
        ]
        USER=os.getenv("HOME")
        logger.info(ACTOR+'Setting files to backup')
        BACKUPFILES.append(USER+"/.lirc")
        ## Set up backup location
        TMPDIR="/tmp/mythbuntu-bare"
        logger.info(ACTOR+'Creating temp directory at'+str(TMPDIR))
        if not os.path.exists(TMPDIR):
            os.makedirs(TMPDIR)
        BACKUPFILES.append(TMPDIR)
        ## Set status file
        STATUSFILE="/tmp/mythbuntu-bare-status"
        logger.info(ACTOR+'Setting status file to '+str(STATUSFILE))
        if os.path.isfile(STATUSFILE):
            os.remove(STATUSFILE)
        timestamp=time.strftime("%Y%m%d-%H%M", time.localtime())
        ## Backup database only if told to do so
        DBB=""
        MBE=""
        logger.info(ACTOR+'Detecting Master Backend')
        if os.path.isdir("/usr/share/doc/mythtv-backend-master"):
          logger.info(ACTOR+'Master Backend status is True')
          MBE="_MBE"
          DBB="_NODB"
          if BackupDB == True:
            logger.info(ACTOR+'Backing up database')
            #Run DB Backup
            os.system("echo '20\nBacking up database (this could take a few minutes)'>"+STATUSFILE)
            backupscript="/usr/share/mythtv/mythconverg_backup.pl"
            pipe = subprocess.Popen([backupscript, '--directory', TMPDIR], stdout=subprocess.PIPE).communicate()
            DBB="_YESDB"
          else:
            logger.info(ACTOR+'Database set to not be backed up')
        else:
          logger.info(ACTOR+'Master Backend status is False')
        ## Setup for final tar file
        hostname = platform.node()
        logger.info(ACTOR+'Hostname is '+str(hostname))
        tarfilename=Location+'/mythbuntu-system-backup_'+hostname+'_'+timestamp+MBE+DBB+'.tar.gz'
        logger.info(ACTOR+'Tarfile is '+str(tarfilename))
        TF=tarfile.open(tarfilename,mode='w:gz')
        os.system("echo '90\nZipping up files'>"+STATUSFILE)
	## Add files to tarball
        for item in BACKUPFILES:
          logger.info(ACTOR+'Backing up files')
          if os.path.exists(item):
            TF.add(item)
        TF.close()
        ## Check if managed and push file to server if necessary
        config = ConfigParser.ConfigParser()
        config.read("/var/lib/mythtv/bare-client/mythbuntu-bare-client.conf")
        managed = config.get("General", "managed")
        if managed:
          logger.info(ACTOR+'Pushing backup file to server')
          ServerIP = config.get("General", "serverip")
          ServerPort = config.get("General", "serverport")
          pipe = subprocess.Popen(["/usr/share/mythbuntu-bare/bareclient/bare/push_file.py", 'http://'+ServerIP+":"+ServerPort+"/cgi-bin/save_file.py", tarfilename], stdout=subprocess.PIPE).communicate()
        else:
          logger.info(ACTOR+'Machine unmanaged')
        lbt = open(Location+"/lastbackuptime.log", 'w')
        lbt.write(str(datetime.datetime.now()))
        lbt.close()
        ## Remove tmp Backup directory and status file
        logger.info(ACTOR+'Removing temp files')
        if os.path.exists(TMPDIR):
            shutil.rmtree(TMPDIR)
        if os.path.isfile(STATUSFILE):
            os.remove(STATUSFILE)
        logger.info(ACTOR+'Backup job finished')
