/* Copyright (C) 2008-2009 Sun Microsystems, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef MY_DAEMON_H
#define MY_DAEMON_H

C_MODE_START


typedef int (*my_daemon_run_t)(int, char**);
typedef void (*my_daemon_stop_t)(void);

/*
  Used from "mini" main to run an application as a
  service on windows, where the "run" function will be run
  as a service if first arg is --service=<service_name>.

  Defaults to "normal" behaviour which is to call "run" directly
  with argc/argv

*/
int my_daemon_init(int argc, char** argv,
                   my_daemon_run_t run, my_daemon_stop_t stop,
                   const char* name, const char* display_name);

/*
  To be called at the point where an application needs to daemonize
  itself.

  The daemonizing will on most platforms do a fork itself as a daemon.
  I.e fork, setsid, create pidfile, and redirect all output to logfile.

  On windows, only create pidfile and redirect.
*/
int my_daemonize(const char* pidfile_name, const char *logfile_name);


/*
  To be called when application should exit.

  Performs an ordered shutdown of service if running as a serevice.
 */
void my_daemon_exit(int status);


/*
   if any of the functions in my_daemon return non-zero (failure)
   then my_daemon_error contains the error message
*/

extern char my_daemon_error[];

C_MODE_END

#endif //MY_DAEMON_H
