<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Utils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

if (!isset($_GET["documentid"]) || !is_numeric($_GET["documentid"]) || intval($_GET["documentid"])<1) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}
$documentid = $_GET["documentid"];
$document = getDocument($documentid);
if (!is_object($document)) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}

$folder = $document->getFolder();
$docPathHTML = getFolderPathHTML($folder, true). " / <a href=\"../out/out.ViewDocument.php?documentid=".$documentid."\">".$document->getName()."</a>";
UI::htmlStartPage(getMLText("document_title", array("documentname" => $document->getName())));
UI::globalNavigation($folder);
UI::pageNavigation($docPathHTML, "view_document");
UI::contentHeading(getMLText("override_content_status"));

if ($document->getAccessMode($user) < M_ALL) {
	UI::contentContainer(getMLText("override_privilege_insufficient"));
	UI::htmlEndPage();
	exit;
}

if (!isset($_GET["version"]) || !is_numeric($_GET["version"]) || intval($_GET["version"])<1) {
	UI::contentContainer(getMLText("invalid_version"));
	UI::htmlEndPage();
	exit;
}
$version = $_GET["version"];
$content = $document->getContentByVersion($version);
if (!is_object($content)) {
	// die ("Unable to retrieve version information for document '". $document->getName() ."', version ". $version .".");
	UI::contentContainer(getMLText("invalid_version"));
	UI::htmlEndPage();
	exit;
}
$overallStatus = $content->getStatus();
$reviewStatus = $content->getReviewStatus();
$approvalStatus = $content->getApprovalStatus();

?>
<script language="JavaScript">
function checkForm()
{
	msg = "";
	if (document.form1.overrideStatus.value == "") msg += "<?php printMLText("js_no_override_status");?>\n";
	if (document.form1.comment.value == "") msg += "<?php printMLText("js_no_comment");?>\n";
	if (msg != "")
	{
		alert(msg);
		return false;
	}
	else
		return true;
}
</script>
<?php
UI::contentContainerStart();
// If the document version is in one of the terminal states (expired,
// obsolete, rejected), report a warning.
if ($overallStatus["status"] == -1 || $overallStatus["status"] == -2 || $overallStatus["status"] == -3) {
	printMLText("cannot_change_final_states");
}
else {
	// Display the Review form.
	?>
	<form method="POST" action="../op/op.OverrideContentStatus.php" name="form1" onsubmit="return checkForm();">
	<table>
	<tr><td>Comment:</td>
	<td><textarea name="comment" cols="40" rows="4"></textarea>
	</td></tr>
	<tr><td>New Status:</td>
	<td><select name="overrideStatus">
	<option value=''></option>
	<?php
	if ($overallStatus["status"] != 2) echo "<option value='2'>".getOverallStatusText(2)."</option>";
	if ($overallStatus["status"] != 1 && $overallStatus["status"] != 2) echo "<option value='1'>".getOverallStatusText(1)."</option>";
	if ($overallStatus["status"] != 0 && $overallStatus["status"] != 1 && $overallStatus["status"] != 2) echo "<option value='0'>".getOverallStatusText(0)."</option>";
	if ($overallStatus["status"] != -1) echo "<option value='-1'>".getOverallStatusText(-1)."</option>";
	if ($overallStatus["status"] != -2) echo "<option value='-2'>".getOverallStatusText(-2)."</option>";
	if ($overallStatus["status"] != -3) echo "<option value='-3'>".getOverallStatusText(-3)."</option>";
	?>
	</select>
	</td></tr><tr><td></td><td>
	<input type='hidden' name='documentid' value='<?php echo $documentid ?>'/>
	<input type='hidden' name='version' value='<?php echo $version ?>'/>
	<input type='submit' name='overrideContentStatus' value='Submit Override'/>
	</td></tr></table>
	</form>
	<?php
}
UI::contentContainerEnd();

UI::contentHeading(getMLText("document_infos"));
UI::contentContainerStart();
?>
<table>
<tr>
<td><?php printMLText("owner");?>:</td>
<td>
<?php
$owner = $document->getOwner();
print "<a class=\"infos\" href=\"mailto:".$owner->getEmail()."\">".$owner->getFullName()."</a>";
?>
</td>
</tr>
<tr>
<td><?php printMLText("comment");?>:</td>
<td><?php print $document->getComment();?></td>
</tr>
<tr>
<td><?php printMLText("creation_date");?>:</td>
<td><?php print getLongReadableDate($document->getDate()); ?></td>
</tr>
<tr>
<td><?php printMLText("keywords");?>:</td>
<td><?php print $document->getKeywords();?></td>
</tr>
<?php
if ($document->isLocked()) {
	$lockingUser = $document->getLockingUser();
?>
<tr>
	<td><?php printMLText("lock_status");?>:</td>
	<td><?php printMLText("lock_message", array("email" => $lockingUser->getEmail(), "username" => $lockingUser->getFullName()));?></td>
</tr>
<?php
}
?>
</tr>
</table>
<?php
UI::contentContainerEnd();

UI::contentHeading(getMLText("version_info"));
UI::contentContainerStart();
print "<table class=\"folderView\">";
print "<thead>\n<tr>\n";
print "<th></th>\n";
print "<th>".getMLText("version")."</th>\n";
print "<th>".getMLText("file")."</th>\n";
print "<th>".getMLText("comment")."</th>\n";
print "<th>".getMLText("status")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";
print "<tr>\n";
print "<td><ul class=\"actions\">";
print "<li class=\"first\"><a href=\"../op/op.Download.php?documentid=".$documentid."&version=".$content->getVersion()."\"><img src=\"images/download.gif\" class=\"mimeicon\">".getMLText("download")."</a></dt>";
if ($content->viewOnline())
	print "<li><a target=\"_blank\" href=\"../op/viewonline" . $content->getURL()."\"><img src=\"images/view.gif\" class=\"mimeicon\">" . getMLText("view_online") . "</a></dt>";
print "</ul></td>\n";
print "<td class=\"center\">".$content->getVersion()."</td>\n";
print "<td><dl class=\"documentDetail\">\n";
print "<dt><img class=\"mimeicon\" src=\"images/icons/".UI::getMimeIcon($content->getFileType())."\" title=\"".$content->getMimeType()."\"> ".
	$content->getOriginalFileName() ."</dt>\n";
print "<dd>". filesize($settings->_contentDir . $content->getPath()) ." bytes</dd>\n";
print "<dd>".$content->getMimeType()."</dd>";
$updatingUser = $content->getUser();
print "<dd>".getMLText("uploaded")." ".getLongReadableDate($content->getDate())." by <a href=\"mailto:".$updatingUser->getEmail()."\">".$updatingUser->getFullName()."</a></dd>";
print "<dd>".(!$document->getExpires() ? getMLText("does_not_expire") : getMLText("expires").": ".getReadableDate($document->getExpires()))."</dd>";
print "</dl>";
print "<td>".$content->getComment()."</td>";
print "<td>".getOverallStatusText($overallStatus["status"])."</td>";
print "</tr></tbody>\n</table>\n";

UI::contentSubHeading(getMLText("reviewers"));
print "<table class=\"folderView\">\n";
print "<thead>\n<tr>\n";
print "<th>".getMLText("name")."</th>\n";
print "<th>".getMLText("status")."</th>\n";
print "<th>".getMLText("comment")."</th>";
print "<th>".getMLText("last_update")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";
if (is_array($reviewStatus) && count($reviewStatus)>0) {
	foreach ($reviewStatus as $r) {
		if ($r["status"]!=-2) {
			$required = null;
			switch ($r["type"]) {
				case 0: // Reviewer is an individual.
					$required = getUser($r["required"]);
					if (!is_object($required)) {
						$reqName = getMLText("unknown_user")." '".$r["required"]."'";
					}
					else {
						$reqName = "[I] ".$required->getFullName();
					}
					break;
				case 1: // Reviewer is a group.
					$required = getGroup($r["required"]);
					if (!is_object($required)) {
						$reqName = getMLText("unknown_group")." '".$r["required"]."'";
					}
					else {
						$reqName = "[G] ".$required->getName();
					}
					break;
			}
			print "<tr>\n";
			print "<td>".$reqName."</td>\n";
			print "<td>".getReviewStatusText($r["status"])."</td>\n";
			print "<td>".$r["comment"]."</td>\n";
			print "<td>".$r["date"];
			$updateUser = getUser($r["userID"]);
			print " by ".(is_object($updateUser) ? $updateUser->getFullName() : "unknown user id '".$r["userID"]."'");
			print "</td>\n</tr>\n";
		}
	}
}
else {
	print "<tr><td colspan=4>".getMLText("no_reviewers")."</td></tr>\n";
}
print	"</tbody>\n</table>\n";

UI::contentSubHeading(getMLText("approvers"));
print "<table class=\"folderView\">\n";
print "<thead>\n<tr>\n";
print "<th>".getMLText("name")."</th>\n";
print "<th>".getMLText("status")."</th>\n";
print "<th>".getMLText("comment")."</th>";
print "<th>".getMLText("last_update")."</th>\n";
print "</tr>\n</thead>\n<tbody>\n";
if (is_array($approvalStatus) && count($approvalStatus)>0) {
	foreach ($approvalStatus as $a) {
		if ($a["status"]!=-2) {
			$required = null;
			switch ($a["type"]) {
				case 0: // Approver is an individual.
					$required = getUser($a["required"]);
					if (!is_object($required)) {
						$reqName = getMLText("unknown_user")." '".$r["required"]."'";
					}
					else {
						$reqName = "[I] ".$required->getFullName();
					}
					break;
				case 1: // Approver is a group.
					$required = getGroup($a["required"]);
					if (!is_object($required)) {
						$reqName = getMLText("unknown_group")." '".$r["required"]."'";
					}
					else {
						$reqName = "[G] ".$required->getName();
					}
					break;
			}
			print "<tr>\n";
			print "<td>".$reqName."</td>\n";
			print "<td>".getApprovalStatusText($a["status"])."</td>\n";
			print "<td>".$a["comment"]."</td>\n";
			print "<td>".$a["date"];
			$updateUser = getUser($a["userID"]);
			print " by ".(is_object($updateUser) ? $updateUser->getFullName() : "unknown user id '".$a["userID"]."'");
			print "</td>\n</tr>\n";
		}
	}
}
else {
	print "<tr><td colspan=4>".getMLText("no_approvers")."</td></tr>\n";
}
print	"</tbody>\n</table>\n";
UI::contentContainerEnd();
UI::htmlEndPage();
?>
