<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

// Check to see if the user wants to see only those documents that are still
// in the review / approve stages.
$showInProcess = true;
if (isset($_GET["allDocs"]) && strlen($_GET["allDocs"])>0 && $_GET["allDocs"]!=0) {
	$showInProcess = false;
}
$showAllVersions = false;
if (isset($_GET["allVersions"]) && strlen($_GET["allVersions"])>0 && $_GET["allVersions"]!=0) {
	$showAllVersions = true;
}

UI::htmlStartPage(getMLText("approval_summary"));
UI::globalNavigation();
UI::pageNavigation(getMLText("approval_summary"), "approval_summary");

if (!$db->createTemporaryTable("ttstatid")) {
	UI::contentHeading(getMLText("warning"));
	UI::contentContainer(getMLText("internal_error_exit"));
	UI::htmlEndPage();
	exit;
}

// Get document list for the current user.
$approvalStatus = $user->getApprovalStatus();
// Create a comma separated list of all the documentIDs whose information is
// required.
$dList = array();
foreach ($approvalStatus["indstatus"] as $st) {
	if (!in_array($st["documentID"], $dList)) {
		$dList[] = $st["documentID"];
	}
}
foreach ($approvalStatus["grpstatus"] as $st) {
	if (!in_array($st["documentID"], $dList)) {
		$dList[] = $st["documentID"];
	}
}
$docCSV = "";
foreach ($dList as $d) {
	$docCSV .= (strlen($docCSV)==0 ? "" : ", ")."'".$d."'";
}

if (strlen($docCSV)>0) {
	if (!$showAllVersions) {
		if (!$db->createTemporaryTable("ttcontentid")) {
			UI::contentHeading(getMLText("warning"));
			UI::contentContainer(getMLText("internal_error_exit"));
			UI::htmlEndPage();
			exit;
		}
		$queryStr = "SELECT `tblDocuments`.*, `tblDocumentLocks`.`userID` as `lockUser`, ".
			"`tblDocumentContent`.`version`, `tblDocumentStatus`.*, `tblDocumentStatusLog`.`status`, ".
			"`tblDocumentStatusLog`.`comment` AS `statusComment`, `tblDocumentStatusLog`.`date` as `statusDate`, ".
			"`tblDocumentStatusLog`.`userID`, `oTbl`.`fullName` AS `ownerName`, `sTbl`.`fullName` AS `statusName` ".
			"FROM `tblDocumentContent` ".
			"LEFT JOIN `tblDocuments` ON `tblDocuments`.`id` = `tblDocumentContent`.`document` ".
			"LEFT JOIN `tblDocumentStatus` ON `tblDocumentStatus`.`documentID` = `tblDocumentContent`.`document` ".
			"LEFT JOIN `tblDocumentStatusLog` ON `tblDocumentStatusLog`.`statusID` = `tblDocumentStatus`.`statusID` ".
			"LEFT JOIN `ttstatid` ON `ttstatid`.`maxLogID` = `tblDocumentStatusLog`.`statusLogID` ".
			"LEFT JOIN `ttcontentid` ON `ttcontentid`.`maxVersion` = `tblDocumentStatus`.`version` AND `ttcontentid`.`document` = `tblDocumentStatus`.`documentID` ".
			"LEFT JOIN `tblDocumentLocks` ON `tblDocuments`.`id`=`tblDocumentLocks`.`document` ".
			"LEFT JOIN `tblUsers` AS `oTbl` on `oTbl`.`id` = `tblDocuments`.`owner` ".
			"LEFT JOIN `tblUsers` AS `sTbl` on `sTbl`.`id` = `tblDocumentStatusLog`.`userID` ".
			"WHERE `ttstatid`.`maxLogID`=`tblDocumentStatusLog`.`statusLogID` ".
			"AND `ttcontentid`.`maxVersion` = `tblDocumentContent`.`version` ".
			($showInProcess ? "AND `tblDocumentStatusLog`.`status` = 1 " : "").
			"AND `tblDocuments`.`id` IN (" . $docCSV . ") ".
			"ORDER BY `sequence`";
	}
	else {
		$queryStr = "SELECT `tblDocuments`.*, `tblDocumentLocks`.`userID` as `lockUser`, ".
			"`tblDocumentStatus`.*, `tblDocumentStatusLog`.`status`, ".
			"`tblDocumentStatusLog`.`comment` AS `statusComment`, `tblDocumentStatusLog`.`date` as `statusDate`, ".
			"`tblDocumentStatusLog`.`userID`, `oTbl`.`fullName` AS `ownerName`, `sTbl`.`fullName` AS `statusName` ".
			"FROM `tblDocumentStatus` ".
			"LEFT JOIN `tblDocumentStatusLog` USING (`statusID`) ".
			"LEFT JOIN `ttstatid` on `ttstatid`.`maxLogID` = `tblDocumentStatusLog`.`statusLogID` ".
			"LEFT JOIN `tblDocuments` ON `tblDocuments`.`id` = `tblDocumentStatus`.`documentID` ".
			"LEFT JOIN `tblDocumentLocks` ON `tblDocuments`.`id`=`tblDocumentLocks`.`document` ".
			"LEFT JOIN `tblUsers` AS `oTbl` on `oTbl`.`id` = `tblDocuments`.`owner` ".
			"LEFT JOIN `tblUsers` AS `sTbl` on `sTbl`.`id` = `tblDocumentStatusLog`.`userID` ".
			"WHERE `ttstatid`.`maxLogID`=`tblDocumentStatusLog`.`statusLogID` ".
			"AND `tblDocuments`.`id` IN (" . $docCSV . ") ".
			($showInProcess ? "AND `tblDocumentStatusLog`.`status` = 1 " : "").
			"ORDER BY `sequence`";
	}
	$resArr = $db->getResultArray($queryStr);
	if (is_bool($resArr) && !$resArr) {
		UI::contentHeading(getMLText("warning"));
		UI::contentContainer(getMLText("internal_error_exit"));
		UI::htmlEndPage();
		exit;
	}
	// Create an array to hold all of these results, and index the array by
	// document id. This makes it easier to retrieve document ID information
	// later on and saves us having to repeatedly poll the database every time
	// new document information is required.
	$docIdx = array();
	foreach ($resArr as $res) {
		$docIdx[$res["id"]][$res["version"]] = $res;
	}

	// List the documents where an approval has been requested.
	$uriVars = "allDocs=".($showInProcess ? "0" : "1")."&allVersions=".($showAllVersions ? "0" : "1");
	UI::contentHeading(getMLText(($showInProcess ? "documents_to_approve" : "all_documents")).
										 " (<a href=\"../out/out.ApprovalSummary.php?".$uriVars."\">".
										 getMLText(($showAllVersions ? "show_current_versions" : "show_all_versions"))."</a>)");
	UI::contentContainerStart();
	print "<table class=\"folderView\">";
	print "<thead>\n<tr>\n";
	print "<th></th>\n";
	print "<th>".getMLText("name")."</th>\n";
	print "<th>".getMLText("owner")."</th>\n";
	print "<th>".getMLText("status")."</th>\n";
	print "<th>".getMLText("version")."</th>\n";
	print "<th>".getMLText("last_update")."</th>\n";
	print "<th>".getMLText("actions")."</th>\n";
	print "</tr>\n</thead>\n<tbody>\n";
	$approvalListEmpty = true;
	$iRev = array();
		foreach ($approvalStatus["indstatus"] as $st) {
			if ($st["status"]==0 && isset($docIdx[$st["documentID"]][$st["version"]])) {
				print "<tr>\n";
				print "<td><img src=\"images/file.gif\" width=18 height=18 border=0></td>";
				print "<td><a href=\"out.ViewDocument.php?documentid=".$st["documentID"]."\">".$docIdx[$st["documentID"]][$st["version"]]["name"]."</a></td>";
				print "<td>".$docIdx[$st["documentID"]][$st["version"]]["ownerName"]."</td>";
				print "<td>".getOverallStatusText($docIdx[$st["documentID"]][$st["version"]]["status"])."</td>";
				print "<td class=\"center\">".$st["version"]."</td>";
				print "<td>".$st["date"];
				print " by ". $docIdx[$st["documentID"]][$st["version"]]["statusName"] ."</td><td>";
				if ($docIdx[$st["documentID"]][$st["version"]]["status"]==0) {
					printMLText("no_action_required");
				}
				else {
					echo "<a href='../out/out.ApproveDocument.php?documentid=".$st["documentID"]."&version=".$st["version"]."'>".getMLText("submit_approval")."</a>";
				}
				print "</td>\n</tr>\n";
				$approvalListEmpty = false;
			}
			if ($st["status"]!=-2) {
				$iRev[] = $st["documentID"];
			}
		}
		foreach ($approvalStatus["grpstatus"] as $st) {
			if (!in_array($st["documentID"], $iRev) && $st["status"]==0 && isset($docIdx[$st["documentID"]][$st["version"]])) {
				print "<tr>\n";
				print "<td><img src=\"images/file.gif\" width=18 height=18 border=0></td>";
				print "<td><a href=\"out.ViewDocument.php?documentid=".$st["documentID"]."\">".$docIdx[$st["documentID"]][$st["version"]]["name"]."</a></td>";
				print "<td>".$docIdx[$st["documentID"]][$st["version"]]["ownerName"]."</td>";
				print "<td>".getOverallStatusText($docIdx[$st["documentID"]][$st["version"]]["status"])."</td>";
				print "<td class=\"center\">".$st["version"]."</td>";
				print "<td>".$st["date"];
				print " by ". $docIdx[$st["documentID"]][$st["version"]]["statusName"] ."</td><td>";
				if ($docIdx[$st["documentID"]][$st["version"]]["status"]==0) {
					printMLText("no_action_required");
				}
				else {
					echo "<a href='../out/out.ApproveDocument.php?documentid=".$st["documentID"]."&version=".$st["version"]."'>".getMLText("group")." '".$g->getName()."': ".getMLText("submit_approval")."</a>";
				}
				print "</td>\n</tr>\n";
				$approvalListEmpty = false;
			}
		}
	if ($approvalListEmpty) {
		echo "<tr><td colspan=7>".getMLText("no_docs_to_approve")."</td></tr>";
	}
	echo "</tbody>\n</table>\n";
	UI::contentContainerEnd();
}
else {
		UI::contentHeading(getMLText("documents_to_approve"));
		UI::contentContainer(getMLText("no_docs_to_approve"));
}

UI::htmlEndPage();
?>
