/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2010  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CStereoSLAMEKF_H
#define CStereoSLAMEKF_H

#include <mrpt/slam/CRangeBearingKFSLAM.h>
#include <mrpt/stereoslam/CVisualOdometryStereo.h>
#include <mrpt/stereoslam/link_pragmas.h>

namespace mrpt
{
	namespace stereoslam
	{
		using namespace mrpt;
		using namespace mrpt::vision;
		using namespace mrpt::slam;

		struct STSLAMDLLIMPEXP TStereoSLAMEKFOptions : public mrpt::utils::CLoadableOptions
		{
			std::vector<double> sigmas;				//!< Standard deviations considered for the column, row and disparity parameters of the feature extraction process
			
			TStereoSLAMEKFOptions( );				// Constructor

			/** See utils::CLoadableOptions
			  */
			void  loadFromConfigFile(
				const mrpt::utils::CConfigFileBase	&source,
				const std::string					&section);

			/** See utils::CLoadableOptions
			  */
			void  dumpToTextStream(
				mrpt::utils::CStream &out) const;


		}; // end struct TStereoSLAMEKFOptions

		class STSLAMDLLIMPEXP CStereoSLAMEKF
		{
		public:
			/** Constructor
			  */
			CStereoSLAMEKF();

			/** Destructor
			  */
			virtual ~CStereoSLAMEKF();

			/** Process one new action and observations to update the map and robot pose estimate. 
			  */
			void processActionObservation( 
				CActionCollectionPtr	&action, 
				CSensoryFramePtr		&SF ); 		

			/** Load options from a ini-like file/text
			  */
			//void loadOptions( 
			//	const mrpt::utils::CConfigFileBase &ini );


		protected:
			CRangeBearingKFSLAM		m_RBEKFSLAM;					//!< The processor of the EKF SLAM 
			TStereoSLAMEKFOptions	m_options;						//!< Options for the EKF SLAM

			CVisualOdometryStereo	m_vOdometer;					//!< The processor of the stereo visual odometry
		}; // end class 'CStereoSLAMEKF'
	} // end of namespace 'stereoslam'
} // end of namespace 'mrpt'

#endif
