/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2010  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */


/**************************************************************************
 Application: mono-slam

  - 2007:
	The first version of this application, the corresponding classes
	and config files were developed by Antonio J. Ortiz de Galisteo
	as part of his Master Thesis at the University of Malaga (2007).

  - Jan-May 2009:
	- mono-slam updated and integrated back into MRPT by M.A. Amiri Atashgah (MAAA)
	  at the University of Sharif Technology, Tehran, Iran (2009).
	- Application converted into a GUI program (Jose Luis Blanco).

 **************************************************************************/

#include "mono_slamApp.h"

//(*AppHeaders
#include "mono_slamMain.h"
#include <wx/image.h>
//*)

IMPLEMENT_APP(mono_slamApp)

bool mono_slamApp::OnInit()
{
	// Starting in wxWidgets 2.9.0, we must reset numerics locale to "C",
	//  if we want numbers to use "." in all countries. The App::OnInit() is a perfect place to undo
	//  the default wxWidgets settings. (JL @ Sep-2009)
	wxSetlocale(LC_NUMERIC,wxString(wxT("C")));

    //(*AppInitialize
    bool wxsOK = true;
    wxInitAllImageHandlers();
    if ( wxsOK )
    {
    mono_slamDialog Dlg(0);
    SetTopWindow(&Dlg);
    Dlg.ShowModal();
    wxsOK = false;
    }
    //*)
    return wxsOK;

}

// This is to avoid a warning due to a conflict btw wxWidgets and opencv 1.1.0
//  related to OLE initialization (See http://trac.wxwidgets.org/ticket/10505 )
bool mono_slamApp::Initialize( int& argc, wxChar **argv )
{
#ifdef MRPT_OS_WINDOWS
	::CoUninitialize();
#endif

	return wxApp::Initialize( argc, argv );
}



